/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.interceptors.ExceptionHandler;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.QueryHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExceptionHandlerTest {
    private static final String COMMAND_HANDLER_INVOKED = "command";
    private static final String EVENT_HANDLER_INVOKED = "event";
    private static final String QUERY_HANDLER_INVOKED = "query";
    private AtomicReference<String> invokedHandler;
    private List<String> invokedExceptionHandlers;
    private ExceptionHandlingComponent messageHandlingComponent;
    private AnnotatedHandlerInspector<ExceptionHandlingComponent> inspector;

    ExceptionHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.invokedHandler = new AtomicReference();
        this.invokedExceptionHandlers = new ArrayList<String>();
        this.messageHandlingComponent = new ExceptionHandlingComponent(this.invokedHandler, this.invokedExceptionHandlers);
        this.inspector = AnnotatedHandlerInspector.inspectType(ExceptionHandlingComponent.class);
    }

    @Test
    void exceptionHandlerIsInvokedForAnCommandHandlerThrowingAnException() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)new SomeCommand(() -> new RuntimeException("some-exception")));
        try {
            Object result = this.handle((Message<?>)command);
            Assertions.assertNull((Object)result);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
        }
        Assertions.assertEquals((Object)COMMAND_HANDLER_INVOKED, (Object)this.invokedHandler.get());
        Assertions.assertTrue((boolean)this.invokedExceptionHandlers.contains("leastSpecificExceptionHandler"));
    }

    @Test
    void exceptionHandlerIsInvokedForAnEventHandlerThrowingAnException() {
        EventMessage event = GenericEventMessage.asEventMessage((Object)new SomeEvent(() -> new RuntimeException("some-exception")));
        try {
            Object result = this.handle((Message<?>)event);
            Assertions.assertNull((Object)result);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
        }
        Assertions.assertEquals((Object)EVENT_HANDLER_INVOKED, (Object)this.invokedHandler.get());
        Assertions.assertTrue((boolean)this.invokedExceptionHandlers.contains("leastSpecificExceptionHandler"));
    }

    @Test
    void exceptionHandlerIsInvokedForAnQueryHandlerThrowingAnException() {
        GenericQueryMessage query = new GenericQueryMessage((Object)new SomeQuery(() -> new RuntimeException("some-exception")), ResponseTypes.instanceOf(SomeQueryResponse.class));
        try {
            Object result = this.handle((Message<?>)query);
            Assertions.assertNull((Object)result);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
        }
        Assertions.assertEquals((Object)QUERY_HANDLER_INVOKED, (Object)this.invokedHandler.get());
        Assertions.assertTrue((boolean)this.invokedExceptionHandlers.contains("leastSpecificExceptionHandler"));
    }

    @Test
    void exceptionHandlersAreInvokedInHandlerPriorityOrder() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)new SomeCommand(() -> new IllegalStateException("some-exception")));
        Assertions.assertThrows(IllegalStateException.class, () -> this.handle((Message<?>)command));
        Assertions.assertEquals((Object)COMMAND_HANDLER_INVOKED, (Object)this.invokedHandler.get());
        Assertions.assertEquals(Arrays.asList("handleIllegalStateExceptionForSomeCommand", "handleExceptionForSomeCommand", "handleExceptionForSomeCommandThroughAnnotation", "handleIllegalStateExceptionForSomeCommandThroughAnnotation", "handleIllegalStateException", "handleIllegalStateExceptionThroughAnnotation", "leastSpecificExceptionHandler"), this.invokedExceptionHandlers);
    }

    private Object handle(Message<?> message) throws Exception {
        Optional<MessageHandlingMember> handler = this.inspector.getHandlers(ExceptionHandlingComponent.class).filter(h -> h.canHandle(message)).findFirst();
        if (handler.isPresent()) {
            MessageHandlerInterceptorMemberChain interceptorChain = this.inspector.chainedInterceptor(ExceptionHandlingComponent.class);
            return interceptorChain.handle(message, (Object)this.messageHandlingComponent, handler.get());
        }
        return null;
    }

    private static class SomeQueryResponse {
        private SomeQueryResponse() {
        }
    }

    private static class SomeQuery {
        private final Supplier<Exception> exceptionSupplier;

        private SomeQuery(Supplier<Exception> exceptionSupplier) {
            this.exceptionSupplier = exceptionSupplier;
        }
    }

    private static class SomeEvent {
        private final Supplier<Exception> exceptionSupplier;

        private SomeEvent(Supplier<Exception> exceptionSupplier) {
            this.exceptionSupplier = exceptionSupplier;
        }
    }

    private static class SomeCommand {
        private final Supplier<Exception> exceptionSupplier;

        private SomeCommand(Supplier<Exception> exceptionSupplier) {
            this.exceptionSupplier = exceptionSupplier;
        }
    }

    private static class ExceptionHandlingComponent {
        private final AtomicReference<String> invokedHandler;
        private final List<String> invokedExceptionHandlers;

        private ExceptionHandlingComponent(AtomicReference<String> invokedHandler, List<String> invokedExceptionHandlers) {
            this.invokedHandler = invokedHandler;
            this.invokedExceptionHandlers = invokedExceptionHandlers;
        }

        @ExceptionHandler
        public void leastSpecificExceptionHandler() {
            this.invokedExceptionHandlers.add("leastSpecificExceptionHandler");
            throw new IllegalStateException("leastSpecificExceptionHandler");
        }

        @ExceptionHandler(resultType=IllegalStateException.class)
        public void handleRuntimeExceptionThroughAnnotation() {
            this.invokedExceptionHandlers.add("handleIllegalStateExceptionThroughAnnotation");
            throw new IllegalStateException("handleIllegalStateExceptionThroughAnnotation");
        }

        @ExceptionHandler
        public void handleIllegalStateException(IllegalStateException exception) {
            this.invokedExceptionHandlers.add("handleIllegalStateException");
            throw exception;
        }

        @ExceptionHandler(resultType=IllegalStateException.class, payloadType=SomeCommand.class)
        public void handleIllegalStateExceptionForSomeCommandThroughAnnotation() {
            this.invokedExceptionHandlers.add("handleIllegalStateExceptionForSomeCommandThroughAnnotation");
            throw new IllegalStateException("handleIllegalStateExceptionForSomeCommandThroughAnnotation");
        }

        @ExceptionHandler(payloadType=SomeCommand.class)
        public void handleExceptionForSomeCommandThroughAnnotation() {
            this.invokedExceptionHandlers.add("handleExceptionForSomeCommandThroughAnnotation");
            throw new IllegalStateException("handleExceptionForSomeCommandThroughAnnotation");
        }

        @ExceptionHandler
        public void handleExceptionForSomeCommand(SomeCommand command) {
            this.invokedExceptionHandlers.add("handleExceptionForSomeCommand");
            throw new IllegalStateException("handleExceptionForSomeCommand");
        }

        @ExceptionHandler
        public void handleRuntimeExceptionForSomeCommand(SomeCommand command, IllegalStateException exception) {
            this.invokedExceptionHandlers.add("handleIllegalStateExceptionForSomeCommand");
            throw exception;
        }

        @CommandHandler
        public void handle(SomeCommand command) throws Exception {
            this.invokedHandler.set(ExceptionHandlerTest.COMMAND_HANDLER_INVOKED);
            throw (Exception)command.exceptionSupplier.get();
        }

        @EventHandler
        public void on(SomeEvent event) throws Exception {
            this.invokedHandler.set(ExceptionHandlerTest.EVENT_HANDLER_INVOKED);
            throw (Exception)event.exceptionSupplier.get();
        }

        @QueryHandler
        public SomeQueryResponse handle(SomeQuery query) throws Exception {
            this.invokedHandler.set(ExceptionHandlerTest.QUERY_HANDLER_INVOKED);
            throw (Exception)query.exceptionSupplier.get();
        }
    }
}

