/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors.legacyvalidation;

import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.interceptors.legacyvalidation.BeanValidationInterceptor;
import org.axonframework.messaging.interceptors.legacyvalidation.JSR303ViolationException;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BeanValidationInterceptorTest {
    private BeanValidationInterceptor<Message<?>> testSubject;
    private InterceptorChain interceptorChain;
    private UnitOfWork<Message<?>> uow;

    BeanValidationInterceptorTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new BeanValidationInterceptor();
        this.interceptorChain = (InterceptorChain)Mockito.mock(InterceptorChain.class);
        this.uow = new DefaultUnitOfWork(null);
    }

    @Test
    void validateSimpleObject() throws Exception {
        this.uow.transformMessage(m -> new GenericMessage((Object)"Simple instance"));
        this.testSubject.handle(this.uow, this.interceptorChain);
        ((InterceptorChain)Mockito.verify((Object)this.interceptorChain)).proceed();
    }

    @Test
    void validateAnnotatedObject_IllegalNullValue() throws Exception {
        this.uow.transformMessage(m -> new GenericMessage((Object)new JSR303AnnotatedInstance(null)));
        try {
            this.testSubject.handle(this.uow, this.interceptorChain);
            Assertions.fail((String)"Expected exception");
        }
        catch (JSR303ViolationException e) {
            Assertions.assertFalse((boolean)e.getViolations().isEmpty());
        }
        ((InterceptorChain)Mockito.verify((Object)this.interceptorChain, (VerificationMode)Mockito.never())).proceed();
    }

    @Test
    void validateAnnotatedObject_LegalValue() throws Exception {
        this.uow.transformMessage(m -> new GenericMessage((Object)new JSR303AnnotatedInstance("abc")));
        this.testSubject.handle(this.uow, this.interceptorChain);
        ((InterceptorChain)Mockito.verify((Object)this.interceptorChain)).proceed();
    }

    @Test
    void validateAnnotatedObject_IllegalValue() throws Exception {
        this.uow.transformMessage(m -> new GenericMessage((Object)new JSR303AnnotatedInstance("bea")));
        try {
            this.testSubject.handle(this.uow, this.interceptorChain);
            Assertions.fail((String)"Expected exception");
        }
        catch (JSR303ViolationException e) {
            Assertions.assertFalse((boolean)e.getViolations().isEmpty());
        }
        ((InterceptorChain)Mockito.verify((Object)this.interceptorChain, (VerificationMode)Mockito.never())).proceed();
    }

    @Test
    void customValidatorFactory() throws Exception {
        this.uow.transformMessage(m -> new GenericMessage((Object)new JSR303AnnotatedInstance("abc")));
        ValidatorFactory mockValidatorFactory = (ValidatorFactory)Mockito.spy((Object)Validation.buildDefaultValidatorFactory());
        this.testSubject = new BeanValidationInterceptor(mockValidatorFactory);
        this.testSubject.handle(this.uow, this.interceptorChain);
        ((ValidatorFactory)Mockito.verify((Object)mockValidatorFactory)).getValidator();
    }

    public static class JSR303AnnotatedInstance {
        @Pattern(regexp="ab.*")
        @NotNull
        private @Pattern(regexp="ab.*") @NotNull String notNull;

        public JSR303AnnotatedInstance(String notNull) {
            this.notNull = notNull;
        }
    }
}

