/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMemberDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.annotation.MethodQueryMessageHandlerDefinition;
import org.axonframework.queryhandling.annotation.QueryHandlingMember;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MethodQueryMessageHandlerDefinitionTest {
    private MethodQueryMessageHandlerDefinition testSubject;
    private AnnotatedMessageHandlingMemberDefinition handlerDefinition;
    private ParameterResolverFactory parameterResolver;

    MethodQueryMessageHandlerDefinitionTest() {
    }

    @BeforeEach
    void setUp() {
        this.parameterResolver = ClasspathParameterResolverFactory.forClass(this.getClass());
        this.testSubject = new MethodQueryMessageHandlerDefinition();
        this.handlerDefinition = new AnnotatedMessageHandlingMemberDefinition();
    }

    @Test
    void voidNotAcceptedAsReturnType() {
        Assertions.assertThrows(UnsupportedHandlerException.class, () -> this.messageHandler("illegalQueryResponseType"));
    }

    @Test
    void futureResponseTypeUnwrapped() {
        QueryHandlingMember handler = this.messageHandler("futureReturnType");
        Assertions.assertEquals(String.class, (Object)handler.getResultType());
    }

    @Test
    void optionalResponseTypeUnwrapped() throws Exception {
        QueryHandlingMember handler = this.messageHandler("optionalReturnType");
        Assertions.assertEquals(String.class, (Object)handler.getResultType());
        GenericQueryMessage message = new GenericQueryMessage((Object)"mock", ResponseTypes.instanceOf(String.class));
        Assertions.assertTrue((boolean)handler.canHandle((Message)message));
        Object invocationResult = handler.handle((Message)message, (Object)this);
        Assertions.assertNull((Object)invocationResult);
    }

    @Test
    void unspecifiedOptionalResponseTypeUnwrapped() {
        QueryHandlingMember handler = this.messageHandler("unspecifiedOptionalType");
        Assertions.assertEquals(Object.class, (Object)handler.getResultType());
    }

    @Test
    void wildcardOptionalResponseTypeUnwrapped() {
        QueryHandlingMember handler = this.messageHandler("wildcardOptionalType");
        Assertions.assertEquals(Object.class, (Object)handler.getResultType());
    }

    @Test
    void upperBoundWildcardOptionalResponseTypeUnwrapped() {
        QueryHandlingMember handler = this.messageHandler("upperBoundWildcardOptionalType");
        Assertions.assertEquals(CharSequence.class, (Object)handler.getResultType());
    }

    private <R> QueryHandlingMember<R> messageHandler(String methodName) {
        try {
            MessageHandlingMember handler = (MessageHandlingMember)this.handlerDefinition.createHandler(MethodQueryMessageHandlerDefinitionTest.class, (Executable)MethodQueryMessageHandlerDefinitionTest.class.getDeclaredMethod(methodName, String.class), this.parameterResolver).orElseThrow(IllegalArgumentException::new);
            return (QueryHandlingMember)this.testSubject.wrapHandler(handler).unwrap(QueryHandlingMember.class).orElseThrow(() -> new RuntimeException("Method not recognized as Query Definition"));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method used to build query handler does not exist", e);
        }
    }

    @QueryHandler
    private void illegalQueryResponseType(String string) {
    }

    @QueryHandler
    private CompletableFuture<String> futureReturnType(String string) {
        return null;
    }

    @QueryHandler
    private Optional<String> optionalReturnType(String string) {
        return Optional.empty();
    }

    @QueryHandler
    private Optional unspecifiedOptionalType(String string) {
        return Optional.empty();
    }

    @QueryHandler
    private Optional<?> wildcardOptionalType(String string) {
        return Optional.empty();
    }

    @QueryHandler
    private Optional<? extends CharSequence> upperBoundWildcardOptionalType(String string) {
        return Optional.empty();
    }
}

