/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.registration;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.registration.LoggingDuplicateQueryHandlerResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class LoggingDuplicateQueryHandlerResolverTest {
    private final LoggingDuplicateQueryHandlerResolver resolver = LoggingDuplicateQueryHandlerResolver.instance();

    LoggingDuplicateQueryHandlerResolverTest() {
    }

    @Test
    void throwsNoErrorOnDuplicateHandlerAndAddsItToList() {
        QuerySubscription<?> existingHandler = this.mockSubscription();
        QuerySubscription<?> addedHandler = this.mockSubscription();
        CopyOnWriteArrayList existingHandlers = new CopyOnWriteArrayList();
        existingHandlers.add(existingHandler);
        List resolvedList = this.resolver.resolve("org.axon.MyQuery", MyQuery.class, existingHandlers, addedHandler);
        Assertions.assertEquals((int)2, (int)resolvedList.size());
        Assertions.assertTrue((boolean)resolvedList.contains(existingHandler));
        Assertions.assertTrue((boolean)resolvedList.contains(addedHandler));
    }

    private QuerySubscription<?> mockSubscription() {
        QuerySubscription mock = (QuerySubscription)Mockito.mock(QuerySubscription.class);
        Mockito.when((Object)mock.getQueryHandler()).thenReturn(message -> null);
        Mockito.when((Object)mock.getResponseType()).thenReturn(MyResponse.class);
        return mock;
    }

    private static final class MyResponse {
        private MyResponse() {
        }
    }

    private static final class MyQuery {
        private MyQuery() {
        }
    }
}

