/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.json.JsonNodeToObjectNodeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonNodeToObjectNodeConverterTest {
    private final JsonNodeToObjectNodeConverter testSubject = new JsonNodeToObjectNodeConverter();

    JsonNodeToObjectNodeConverterTest() {
    }

    @Test
    void expectedSourceType() {
        Assertions.assertEquals(JsonNode.class, (Object)this.testSubject.expectedSourceType());
    }

    @Test
    void targetType() {
        Assertions.assertEquals(ObjectNode.class, (Object)this.testSubject.targetType());
    }

    @Test
    void convert() {
        ObjectNode expectedJsonNode = new ObjectNode(JsonNodeFactory.instance);
        ObjectNode result = this.testSubject.convert((JsonNode)expectedJsonNode);
        Assertions.assertEquals((Object)expectedJsonNode, (Object)result);
    }

    @Test
    void convertThrowsException() {
        TextNode testJsonNode = new TextNode("some-text");
        Assertions.assertThrows(SerializationException.class, () -> this.lambda$convertThrowsException$0((JsonNode)testJsonNode));
    }

    private /* synthetic */ void lambda$convertThrowsException$0(JsonNode testJsonNode) throws Throwable {
        this.testSubject.convert(testJsonNode);
    }
}

