/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.axonframework.tracing.TracingHandlerEnhancerDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TracingHandlerEnhancerDefinitionTest {
    private final MessageHandlingMember<TracingHandlerEnhancerDefinitionTest> original = (MessageHandlingMember)Mockito.mock(MessageHandlingMember.class);
    private final TestSpanFactory spanFactory = new TestSpanFactory();
    private final Span span = (Span)Mockito.mock(Span.class);
    private boolean invoked = false;

    TracingHandlerEnhancerDefinitionTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.span.runCallable((Callable)Mockito.any())).thenCallRealMethod();
        Method executable = this.getClass().getDeclaredMethod("executable", MyEvent.class, CommandGateway.class);
        Mockito.when((Object)this.original.unwrap(Executable.class)).thenReturn(Optional.of(executable));
    }

    private void setupOriginal(boolean eventSourcingHandler) {
        if (eventSourcingHandler) {
            Mockito.when((Object)this.original.attribute("EventSourcingHandler.payloadType")).thenReturn(Optional.of("value"));
        } else {
            Mockito.when((Object)this.original.attribute("EventSourcingHandler.payloadType")).thenReturn(Optional.empty());
        }
    }

    @Test
    void showsWhenNotEventSourcingHandler() throws Exception {
        this.setupOriginal(false);
        TracingHandlerEnhancerDefinition definition = TracingHandlerEnhancerDefinition.builder().spanFactory((SpanFactory)this.spanFactory).showEventSourcingHandlers(false).build();
        MessageHandlingMember messageHandlingMember = definition.wrapHandler(this.original);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)this.original.handle((Message)Mockito.any(), Mockito.any())).thenAnswer(invocationOnMock -> {
            this.spanFactory.verifySpanActive("TracingHandlerEnhancerDefinitionTest.executable(MyEvent,CommandGateway)");
            this.invoked = true;
            return null;
        });
        messageHandlingMember.handle(message, (Object)this);
        Assertions.assertTrue((boolean)this.invoked);
        this.spanFactory.verifySpanCompleted("TracingHandlerEnhancerDefinitionTest.executable(MyEvent,CommandGateway)");
    }

    @Test
    void doesNotShowWhenEventSourcingHandler() throws Exception {
        this.setupOriginal(true);
        TracingHandlerEnhancerDefinition definition = TracingHandlerEnhancerDefinition.builder().spanFactory((SpanFactory)this.spanFactory).showEventSourcingHandlers(false).build();
        MessageHandlingMember messageHandlingMember = definition.wrapHandler(this.original);
        Assertions.assertSame(this.original, (Object)messageHandlingMember);
    }

    @Test
    void showsWhenEventSourcingHandlerButOptionIsTrue() throws Exception {
        this.setupOriginal(true);
        TracingHandlerEnhancerDefinition definition = TracingHandlerEnhancerDefinition.builder().spanFactory((SpanFactory)this.spanFactory).showEventSourcingHandlers(true).build();
        MessageHandlingMember messageHandlingMember = definition.wrapHandler(this.original);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)this.original.handle((Message)Mockito.any(), Mockito.any())).thenAnswer(invocationOnMock -> {
            this.spanFactory.verifySpanActive("TracingHandlerEnhancerDefinitionTest.executable(MyEvent,CommandGateway)");
            this.invoked = true;
            return null;
        });
        messageHandlingMember.handle(message, (Object)this);
        Assertions.assertTrue((boolean)this.invoked);
        this.spanFactory.verifySpanCompleted("TracingHandlerEnhancerDefinitionTest.executable(MyEvent,CommandGateway)");
    }

    @Test
    void canNotSetSpanFactoryToNull() {
        TracingHandlerEnhancerDefinition.Builder builder = TracingHandlerEnhancerDefinition.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.spanFactory(null));
    }

    @Test
    void canNotBuildeWithoutSpanFactory() {
        TracingHandlerEnhancerDefinition.Builder builder = TracingHandlerEnhancerDefinition.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((TracingHandlerEnhancerDefinition.Builder)builder).build());
    }

    private void executable(MyEvent event, CommandGateway commandGateway) {
    }

    private class MyEvent {
        private MyEvent() {
        }
    }
}

