/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing.attributes;

import java.util.Map;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.attributes.MessageNameSpanAttributesProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageNameSpanAttributesProviderTest {
    private final SpanAttributesProvider provider = new MessageNameSpanAttributesProvider();

    MessageNameSpanAttributesProviderTest() {
    }

    @Test
    void extractsNothingForEvent() {
        EventMessage event = GenericEventMessage.asEventMessage((Object)"Some event");
        Map map = this.provider.provideForMessage((Message)event);
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    void extractsForQueryWithSpecificName() {
        GenericQueryMessage genericQueryMessage = new GenericQueryMessage((Object)"MyQuery", "myQueryName", ResponseTypes.instanceOf(String.class));
        Map map = this.provider.provideForMessage((Message)genericQueryMessage);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"myQueryName", map.get("axon_message_name"));
    }

    @Test
    void extractsForQueryWithPayloadName() {
        GenericQueryMessage genericQueryMessage = new GenericQueryMessage((Object)"MyQuery", ResponseTypes.instanceOf(String.class));
        Map map = this.provider.provideForMessage((Message)genericQueryMessage);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"java.lang.String", map.get("axon_message_name"));
    }

    @Test
    void extractsForCommandWithSpecificName() {
        GenericCommandMessage genericQueryMessage = new GenericCommandMessage((Message)new GenericCommandMessage((Object)"payload"), "MyAwesomeCommand");
        Map map = this.provider.provideForMessage((Message)genericQueryMessage);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"MyAwesomeCommand", map.get("axon_message_name"));
    }

    @Test
    void extractsForCommandWithPayloadName() {
        GenericCommandMessage genericQueryMessage = new GenericCommandMessage((Object)"payload");
        Map map = this.provider.provideForMessage((Message)genericQueryMessage);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"java.lang.String", map.get("axon_message_name"));
    }
}

