/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.utils;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.task.Task;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import javax.sql.DataSource;

public abstract class DbSchedulerTestUtil {
    private DbSchedulerTestUtil() {
    }

    public static void reCreateTable(DataSource dataSource) {
        Throwable throwable;
        PreparedStatement statement;
        Connection connection;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            statement = connection.prepareStatement("drop table if exists scheduled_tasks;");
            throwable = null;
            try {
                statement.execute();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            statement = connection.prepareStatement("create table scheduled_tasks (\n  task_name varchar(40) not null,\n  task_instance varchar(40) not null,\n  task_data blob,\n  execution_time timestamp(6) not null,\n  picked BOOLEAN not null,\n  picked_by varchar(50),\n  last_success timestamp(6) null,\n  last_failure timestamp(6) null,\n  consecutive_failures INT,\n  last_heartbeat timestamp(6) null,\n  version BIGINT not null,\n  PRIMARY KEY (task_name, task_instance),\n)");
            throwable = null;
            try {
                statement.execute();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Scheduler getScheduler(DataSource dataSource, Task<?> task) {
        Scheduler scheduler = new SchedulerBuilder(dataSource, Collections.singletonList(task)).threads(2).pollingInterval(Duration.ofMillis(50L)).build();
        return scheduler;
    }
}

