/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class DeadlineDetails {
    private String deadlineName;
    private String scopeDescriptor;
    private String scopeDescriptorClass;
    private String payload;
    private String payloadClass;
    private String payloadRevision;
    private String metaData;

    private DeadlineDetails() {
    }

    public DeadlineDetails(@Nonnull String deadlineName, @Nonnull String scopeDescriptor, @Nonnull String scopeDescriptorClass, @Nullable String payload, @Nullable String payloadClass, @Nullable String payloadRevision, @Nonnull String metaData) {
        this.deadlineName = deadlineName;
        this.scopeDescriptor = scopeDescriptor;
        this.scopeDescriptorClass = scopeDescriptorClass;
        this.payload = payload;
        this.payloadClass = payloadClass;
        this.payloadRevision = payloadRevision;
        this.metaData = metaData;
    }

    static String serialized(@Nonnull String deadlineName, @Nonnull ScopeDescriptor descriptor, @Nonnull DeadlineMessage message, @Nonnull Serializer serializer) {
        SerializedObject<String> serializedDescriptor = serializer.serialize(descriptor, String.class);
        SerializedObject<String> serializedPayload = serializer.serialize(message.getPayload(), String.class);
        SerializedObject<String> serializedMetaData = serializer.serialize(message.getMetaData(), String.class);
        DeadlineDetails deadlineDetails = new DeadlineDetails(deadlineName, serializedDescriptor.getData(), serializedDescriptor.getType().getName(), serializedPayload.getData(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedMetaData.getData());
        SerializedObject<String> serializedDeadlineDetails = serializer.serialize(deadlineDetails, String.class);
        return serializedDeadlineDetails.getData();
    }

    public String getDeadlineName() {
        return this.deadlineName;
    }

    public String getScopeDescriptor() {
        return this.scopeDescriptor;
    }

    public String getScopeDescriptorClass() {
        return this.scopeDescriptorClass;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getPayloadClass() {
        return this.payloadClass;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public GenericDeadlineMessage asDeadLineMessage(Serializer serializer) {
        return new GenericDeadlineMessage<Object>(this.deadlineName, this.getDeserializedPayload(serializer), this.getDeserializedMetaData(serializer));
    }

    private Object getDeserializedPayload(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlinePayload = new SimpleSerializedObject<String>(this.payload, String.class, this.payloadClass, this.payloadRevision);
        return serializer.deserialize(serializedDeadlinePayload);
    }

    private MetaData getDeserializedMetaData(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlineMetaData = new SimpleSerializedObject<String>(this.metaData, String.class, MetaData.class.getName(), null);
        return (MetaData)serializer.deserialize(serializedDeadlineMetaData);
    }

    public ScopeDescriptor getDeserializedScopeDescriptor(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlineScope = new SimpleSerializedObject<String>(this.scopeDescriptor, String.class, this.scopeDescriptorClass, null);
        return (ScopeDescriptor)serializer.deserialize(serializedDeadlineScope);
    }
}

