/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MetaData;

public class GenericCommandMessage<T>
extends MessageDecorator<T>
implements CommandMessage<T> {
    private static final long serialVersionUID = 3282528436414939876L;
    private final String commandName;

    public static <C> CommandMessage<C> asCommandMessage(@Nonnull Object command) {
        if (command instanceof CommandMessage) {
            return (CommandMessage)command;
        }
        if (command instanceof Message) {
            return new GenericCommandMessage(((Message)command).getPayload(), ((Message)command).getMetaData());
        }
        return new GenericCommandMessage<Object>(command, MetaData.emptyInstance());
    }

    public GenericCommandMessage(@Nonnull T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericCommandMessage(@Nonnull T payload, @Nonnull Map<String, ?> metaData) {
        this(new GenericMessage<T>(payload, metaData), payload.getClass().getName());
    }

    public GenericCommandMessage(@Nonnull Message<T> delegate, @Nonnull String commandName) {
        super(delegate);
        this.commandName = commandName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public GenericCommandMessage<T> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericCommandMessage(this.getDelegate().withMetaData(metaData), this.commandName);
    }

    @Override
    public GenericCommandMessage<T> andMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericCommandMessage(this.getDelegate().andMetaData(metaData), this.commandName);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", commandName='").append(this.getCommandName()).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericCommandMessage";
    }
}

