/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.axonframework.commandhandling.annotations.CommandHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MethodCommandHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        Optional optionalRoutingKey = original.attribute("CommandHandler.routingKey");
        Optional optionalCommandName = original.attribute("CommandHandler.commandName");
        return optionalRoutingKey.isPresent() && optionalCommandName.isPresent() ? new MethodCommandHandlingMember(original, (String)optionalRoutingKey.get(), (String)optionalCommandName.get()) : original;
    }

    private static class MethodCommandHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements CommandHandlingMember<T> {
        private final String commandName;
        private final boolean isFactoryHandler;
        private final String routingKey;

        private MethodCommandHandlingMember(MessageHandlingMember<T> delegate, String routingKeyAttribute, String commandNameAttribute) {
            super(delegate);
            Executable executable = delegate.unwrap(Executable.class).orElseThrow(() -> new AxonConfigurationException("The @CommandHandler annotation must be put on an Executable (either directly or as Meta Annotation)"));
            this.routingKey = "".equals(routingKeyAttribute) ? null : routingKeyAttribute;
            this.commandName = "".equals(commandNameAttribute) ? delegate.payloadType().getName() : commandNameAttribute;
            boolean factoryMethod = executable instanceof Method && Modifier.isStatic(executable.getModifiers());
            this.isFactoryHandler = executable instanceof Constructor || factoryMethod;
        }

        @Override
        public boolean canHandle(@Nonnull Message message, @Nonnull ProcessingContext context) {
            return super.canHandle(message, context);
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }

        @Override
        public String commandName() {
            return this.commandName;
        }

        @Override
        public boolean isFactoryHandler() {
            return this.isFactoryHandler;
        }
    }
}

