/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public abstract class DelegatingCommandBusConnector
implements CommandBusConnector {
    private final CommandBusConnector delegate;

    protected DelegatingCommandBusConnector(@Nonnull CommandBusConnector delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        return this.delegate.dispatch(command, processingContext);
    }

    @Override
    public void subscribe(@Nonnull QualifiedName commandName, int loadFactor) {
        this.delegate.subscribe(commandName, loadFactor);
    }

    @Override
    public boolean unsubscribe(@Nonnull QualifiedName commandName) {
        return this.delegate.unsubscribe(commandName);
    }

    @Override
    public void onIncomingCommand(@Nonnull CommandBusConnector.Handler handler) {
        this.delegate.onIncomingCommand(handler);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
    }
}

