/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.Assert;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.Cache;

public class WeakReferenceCache
implements Cache {
    private final ConcurrentMap<Object, Entry> cache = new ConcurrentHashMap<Object, Entry>();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final Set<Cache.EntryListener> adapters = new CopyOnWriteArraySet<Cache.EntryListener>();

    @Override
    public Registration registerCacheEntryListener(Cache.EntryListener entryListener) {
        this.adapters.add(entryListener);
        return () -> this.adapters.remove(entryListener);
    }

    @Override
    public <K, V> V get(K key) {
        V returnValue;
        Assert.nonNull(key, () -> "Key may not be null");
        this.purgeItems();
        Reference entry = (Reference)this.cache.get(key);
        V v = returnValue = entry == null ? null : (V)entry.get();
        if (returnValue != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRead(key, returnValue);
            }
        }
        return returnValue;
    }

    @Override
    public void put(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values not supported");
        }
        this.purgeItems();
        if (this.cache.put(key, new Entry(this, key, value)) != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryUpdated(key, value);
            }
        } else {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryCreated(key, value);
            }
        }
    }

    @Override
    public boolean putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values not supported");
        }
        this.purgeItems();
        if (this.cache.putIfAbsent(key, new Entry(this, key, value)) == null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryCreated(key, value);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T computeIfAbsent(Object key, Supplier<T> valueSupplier) {
        this.purgeItems();
        Entry currentEntry = (Entry)this.cache.get(key);
        T existingValue = ObjectUtils.getOrDefault(currentEntry, Reference::get, null);
        if (existingValue != null) {
            return existingValue;
        }
        T newValue = valueSupplier.get();
        if (newValue == null) {
            throw new IllegalStateException("Value Supplier of Cache produced a null value for key [" + String.valueOf(key) + "]!");
        }
        this.cache.put(key, new Entry(this, key, newValue));
        for (Cache.EntryListener adapter : this.adapters) {
            adapter.onEntryCreated(key, newValue);
        }
        return newValue;
    }

    @Override
    public boolean remove(Object key) {
        if (this.cache.remove(key) != null) {
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRemoved(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        HashSet keys = new HashSet(this.cache.keySet());
        keys.forEach(key -> {
            this.cache.remove(key);
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRemoved(key);
            }
        });
    }

    @Override
    public boolean containsKey(Object key) {
        Assert.nonNull(key, () -> "Key may not be null");
        this.purgeItems();
        Reference entry = (Reference)this.cache.get(key);
        return entry != null && entry.get() != null;
    }

    private void purgeItems() {
        Entry purgedEntry;
        while ((purgedEntry = (Entry)this.referenceQueue.poll()) != null) {
            if (this.cache.remove(purgedEntry.getKey()) == null) continue;
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryExpired(purgedEntry.getKey());
            }
        }
    }

    @Override
    public <V> void computeIfPresent(Object key, UnaryOperator<V> update) {
        this.purgeItems();
        this.cache.computeIfPresent(key, (? super K k, ? super V v) -> {
            Object currentValue = v.get();
            if (currentValue == null) {
                return null;
            }
            Object value = update.apply(currentValue);
            if (value != null) {
                for (Cache.EntryListener adapter : this.adapters) {
                    adapter.onEntryUpdated(key, value);
                }
                return new Entry(this, k, value);
            }
            for (Cache.EntryListener adapter : this.adapters) {
                adapter.onEntryRemoved(key);
            }
            return null;
        });
    }

    private class Entry
    extends WeakReference<Object> {
        private final Object key;

        public Entry(WeakReferenceCache weakReferenceCache, Object key, Object value) {
            super(value, weakReferenceCache.referenceQueue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

