/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.axonframework.common.Assert;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockAcquisitionFailedException;
import org.axonframework.common.lock.LockFactory;

public class PessimisticLockFactory
implements LockFactory {
    private static final Set<PessimisticLockFactory> INSTANCES = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final ConcurrentHashMap<String, DisposableLock> locks = new ConcurrentHashMap();
    private final int acquireAttempts;
    private final int maximumQueued;
    private final int lockAttemptTimeout;

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner) {
        return PessimisticLockFactory.threadsWaitingForMyLocks(owner, INSTANCES);
    }

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner, Set<PessimisticLockFactory> locksInUse) {
        try {
            HashSet<Thread> waitingThreads = new HashSet<Thread>();
            locksInUse.stream().flatMap(lock -> lock.locks.values().stream()).filter(disposableLock -> disposableLock.isHeldBy(owner)).forEach(disposableLock -> disposableLock.queuedThreads().stream().filter(waitingThreads::add).forEach(thread -> waitingThreads.addAll(PessimisticLockFactory.threadsWaitingForMyLocks(thread, locksInUse))));
            return waitingThreads;
        }
        catch (ConcurrentModificationException e) {
            return Collections.emptySet();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PessimisticLockFactory usingDefaults() {
        return PessimisticLockFactory.builder().build();
    }

    protected PessimisticLockFactory(Builder builder) {
        this.acquireAttempts = builder.acquireAttempts;
        this.maximumQueued = builder.maximumQueued;
        this.lockAttemptTimeout = builder.lockAttemptTimeout;
        INSTANCES.add(this);
    }

    @Override
    public Lock obtainLock(String identifier) {
        Assert.nonNull(identifier, () -> "The identifier to obtain a lock for may not be null.");
        boolean lockObtained = false;
        DisposableLock lock = null;
        while (!lockObtained) {
            lock = this.lockFor(identifier);
            lockObtained = lock.lock();
            if (lockObtained) continue;
            this.locks.remove(identifier, lock);
        }
        return lock;
    }

    private DisposableLock lockFor(String identifier) {
        return this.locks.computeIfAbsent(identifier, x$0 -> new DisposableLock((String)x$0));
    }

    public static class Builder {
        private int acquireAttempts = 6000;
        private int maximumQueued = Integer.MAX_VALUE;
        private int lockAttemptTimeout = 10;

        protected Builder() {
        }

        public Builder acquireAttempts(int acquireAttempts) {
            Assert.isTrue(acquireAttempts > 0 || acquireAttempts == -1, () -> "acquireAttempts needs to be a positive integer or -1, but was '" + acquireAttempts + "'");
            this.acquireAttempts = acquireAttempts;
            return this;
        }

        public Builder queueLengthThreshold(int maximumQueued) {
            Assert.isTrue(maximumQueued > 0, () -> "queueLengthThreshold needs to be a positive integer, but was '" + maximumQueued + "'");
            this.maximumQueued = maximumQueued;
            return this;
        }

        public Builder lockAttemptTimeout(int lockAttemptTimeout) {
            Assert.isTrue(lockAttemptTimeout >= 0, () -> "lockAttemptTimeout needs to be a non negative integer, but was '" + lockAttemptTimeout + "'");
            this.lockAttemptTimeout = lockAttemptTimeout;
            return this;
        }

        public PessimisticLockFactory build() {
            return new PessimisticLockFactory(this);
        }
    }

    private class DisposableLock
    implements Lock {
        private final String identifier;
        private final PubliclyOwnedReentrantLock lock;
        private volatile boolean isClosed = false;

        private DisposableLock(String identifier) {
            this.identifier = identifier;
            this.lock = new PubliclyOwnedReentrantLock();
        }

        @Override
        public void release() {
            try {
                this.lock.unlock();
            }
            finally {
                this.disposeIfUnused();
            }
        }

        @Override
        public boolean isHeld() {
            return this.lock.isHeldByCurrentThread();
        }

        public boolean lock() {
            if (this.lock.getQueueLength() >= PessimisticLockFactory.this.maximumQueued) {
                throw new LockAcquisitionFailedException("Failed to acquire lock for identifier " + this.identifier + ": too many queued threads.");
            }
            try {
                if (!this.lock.tryLock(0L, TimeUnit.NANOSECONDS)) {
                    int attempts = PessimisticLockFactory.this.acquireAttempts - 1;
                    do {
                        this.checkForDeadlock();
                        if (--attempts >= 1) continue;
                        throw new LockAcquisitionFailedException("Failed to acquire lock for identifier(" + this.identifier + "), maximum attempts exceeded (" + PessimisticLockFactory.this.acquireAttempts + ")");
                    } while (!this.lock.tryLock(PessimisticLockFactory.this.lockAttemptTimeout, TimeUnit.MILLISECONDS));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LockAcquisitionFailedException("Thread was interrupted", e);
            }
            if (this.isClosed) {
                this.lock.unlock();
                return false;
            }
            return true;
        }

        private void checkForDeadlock() {
            if (!this.lock.isHeldByCurrentThread() && this.lock.isLocked()) {
                for (Thread thread : PessimisticLockFactory.threadsWaitingForMyLocks(Thread.currentThread())) {
                    if (!this.lock.isHeldBy(thread)) continue;
                    throw new DeadlockException("An imminent deadlock was detected while attempting to acquire a lock");
                }
            }
        }

        private void disposeIfUnused() {
            if (this.lock.tryLock()) {
                try {
                    if (this.lock.getHoldCount() == 1) {
                        this.isClosed = true;
                        PessimisticLockFactory.this.locks.remove(this.identifier, this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public Collection<Thread> queuedThreads() {
            return this.lock.getQueuedThreads();
        }

        public boolean isHeldBy(Thread owner) {
            return this.lock.isHeldBy(owner);
        }
    }

    private static final class PubliclyOwnedReentrantLock
    extends ReentrantLock {
        private PubliclyOwnedReentrantLock() {
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        public boolean isHeldBy(Thread thread) {
            return thread.equals(this.getOwner());
        }
    }
}

