/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.axonframework.common.TypeReference;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentLifecycleHandler;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.InstantiatedComponentDefinition;
import org.axonframework.configuration.LazyInitializedComponentDefinition;

public sealed interface ComponentDefinition<C> {
    public static <C> IncompleteComponentDefinition<C> ofType(@Nonnull Class<C> type) {
        return ComponentDefinition.ofTypeAndName(type, null);
    }

    public static <C> IncompleteComponentDefinition<C> ofTypeAndName(final @Nonnull Class<C> type, final @Nullable String name) {
        return new IncompleteComponentDefinition<C>(){

            @Override
            public ComponentDefinition<C> withInstance(@Nonnull C instance) {
                return new InstantiatedComponentDefinition(new Component.Identifier(type, name), instance);
            }

            @Override
            public ComponentDefinition<C> withBuilder(@Nonnull ComponentBuilder<? extends C> builder) {
                return new LazyInitializedComponentDefinition(new Component.Identifier(type, name), builder);
            }
        };
    }

    public static <C> IncompleteComponentDefinition<C> ofType(@Nonnull TypeReference<C> type) {
        return ComponentDefinition.ofTypeAndName(type, null);
    }

    public static <C> IncompleteComponentDefinition<C> ofTypeAndName(final @Nonnull TypeReference<C> type, final @Nullable String name) {
        return new IncompleteComponentDefinition<C>(){
            private final Component.Identifier<C> identifier;
            {
                this.identifier = new Component.Identifier(type, name);
            }

            @Override
            public ComponentDefinition<C> withInstance(@Nonnull C instance) {
                return new InstantiatedComponentDefinition(this.identifier, instance);
            }

            @Override
            public ComponentDefinition<C> withBuilder(@Nonnull ComponentBuilder<? extends C> builder) {
                return new LazyInitializedComponentDefinition(this.identifier, builder);
            }
        };
    }

    public ComponentDefinition<C> onStart(int var1, @Nonnull ComponentLifecycleHandler<C> var2);

    default public ComponentDefinition<C> onStart(int phase, @Nonnull Consumer<C> handler) {
        return this.onStart(phase, (Configuration config, C component) -> {
            Objects.requireNonNull(handler, "The start handler cannot be null.").accept(component);
            return CompletableFuture.completedFuture(null);
        });
    }

    default public ComponentDefinition<C> onStart(int phase, @Nonnull BiConsumer<Configuration, C> handler) {
        return this.onStart(phase, (Configuration config, C component) -> {
            Objects.requireNonNull(handler, "The start handler cannot be null.").accept(config, component);
            return CompletableFuture.completedFuture(null);
        });
    }

    public ComponentDefinition<C> onShutdown(int var1, @Nonnull ComponentLifecycleHandler<C> var2);

    default public ComponentDefinition<C> onShutdown(int phase, @Nonnull Consumer<C> handler) {
        return this.onShutdown(phase, (Configuration config, C component) -> {
            Objects.requireNonNull(handler, "The shutdown handler cannot be null.").accept(component);
            return CompletableFuture.completedFuture(null);
        });
    }

    default public ComponentDefinition<C> onShutdown(int phase, @Nonnull BiConsumer<Configuration, C> handler) {
        return this.onShutdown(phase, (Configuration config, C component) -> {
            Objects.requireNonNull(handler, "The shutdown handler cannot be null.").accept(config, component);
            return CompletableFuture.completedFuture(null);
        });
    }

    public Class<C> rawType();

    @Nullable
    public String name();

    public static interface IncompleteComponentDefinition<C> {
        public ComponentDefinition<C> withInstance(@Nonnull C var1);

        public ComponentDefinition<C> withBuilder(@Nonnull ComponentBuilder<? extends C> var1);
    }

    public static interface ComponentCreator<C>
    extends ComponentDefinition<C> {
        public Component<C> createComponent();
    }
}

