/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.configuration.CommandHandlingModule;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.DefaultAxonApplication;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.MessagingConfigurationDefaults;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.configuration.EventProcessingConfigurer;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.CorrelationDataProviderRegistry;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;
import org.axonframework.messaging.interceptors.HandlerInterceptorRegistry;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.configuration.QueryHandlingModule;

public class MessagingConfigurer
implements ApplicationConfigurer {
    private final ApplicationConfigurer delegate;
    private final EventProcessingConfigurer eventProcessing;

    private MessagingConfigurer(@Nonnull ApplicationConfigurer delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The Application Configurer cannot be null.");
        this.eventProcessing = new EventProcessingConfigurer(this);
    }

    public static MessagingConfigurer enhance(@Nonnull ApplicationConfigurer applicationConfigurer) {
        return new MessagingConfigurer(applicationConfigurer).componentRegistry(cr -> cr.registerEnhancer(new MessagingConfigurationDefaults()));
    }

    public static MessagingConfigurer create() {
        return MessagingConfigurer.enhance(new DefaultAxonApplication());
    }

    public MessagingConfigurer registerMessageTypeResolver(@Nonnull ComponentBuilder<MessageTypeResolver> messageTypeResolverFactory) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(MessageTypeResolver.class, messageTypeResolverFactory));
        return this;
    }

    public MessagingConfigurer registerCommandBus(@Nonnull ComponentBuilder<CommandBus> commandBusBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(CommandBus.class, commandBusBuilder));
        return this;
    }

    public MessagingConfigurer registerEventSink(@Nonnull ComponentBuilder<EventSink> eventSinkBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(EventSink.class, eventSinkBuilder));
        return this;
    }

    public MessagingConfigurer registerQueryBus(@Nonnull ComponentBuilder<QueryBus> queryBusBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(QueryBus.class, queryBusBuilder));
        return this;
    }

    public MessagingConfigurer registerParameterResolverFactory(@Nonnull ComponentBuilder<ParameterResolverFactory> parameterResolverFactoryBuilder) {
        this.delegate.componentRegistry((ComponentRegistry registry) -> ParameterResolverFactoryUtils.registerToComponentRegistry(registry, parameterResolverFactoryBuilder::build));
        return this;
    }

    public MessagingConfigurer registerUnitOfWorkFactory(@Nonnull ComponentBuilder<UnitOfWorkFactory> unitOfWorkFactoryBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(UnitOfWorkFactory.class, unitOfWorkFactoryBuilder));
        return this;
    }

    public MessagingConfigurer registerCorrelationDataProvider(@Nonnull ComponentBuilder<CorrelationDataProvider> providerBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(CorrelationDataProviderRegistry.class, 0, (config, name, delegate) -> delegate.registerProvider(providerBuilder)));
        return this;
    }

    public MessagingConfigurer registerDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<Message>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerCommandDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerCommandInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerEventDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerQueryDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerQueryInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerMessageHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<Message>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerCommandHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerCommandInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerEventHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super EventMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerQueryHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerQueryInterceptor(interceptorBuilder)));
        return this;
    }

    @Nonnull
    public MessagingConfigurer registerCommandHandlingModule(@Nonnull ModuleBuilder<CommandHandlingModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "The moduleBuilder cannot be null.");
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerModule((Module)moduleBuilder.build()));
        return this;
    }

    @Nonnull
    public MessagingConfigurer registerQueryHandlingModule(@Nonnull ModuleBuilder<QueryHandlingModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "The moduleBuilder cannot be null.");
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerModule((Module)moduleBuilder.build()));
        return this;
    }

    @Override
    public MessagingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.delegate.componentRegistry(Objects.requireNonNull(componentRegistrar, "The configure task must no be null."));
        return this;
    }

    @Override
    public MessagingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.delegate.lifecycleRegistry(Objects.requireNonNull(lifecycleRegistrar, "The lifecycle registrar must not be null."));
        return this;
    }

    public MessagingConfigurer eventProcessing(@Nonnull Consumer<EventProcessingConfigurer> configurerTask) {
        Objects.requireNonNull(configurerTask, "The configurerTask may not be null");
        configurerTask.accept(this.eventProcessing);
        return this;
    }

    @Override
    public AxonConfiguration build() {
        this.eventProcessing.build();
        return this.delegate.build();
    }
}

