/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.axonframework.common.annotations.Internal;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.MessagingConfigurer;
import org.axonframework.eventhandling.configuration.EventProcessorConfiguration;
import org.axonframework.eventhandling.configuration.EventProcessorCustomization;
import org.axonframework.eventhandling.processors.streaming.pooled.PooledStreamingEventProcessorsConfigurer;
import org.axonframework.eventhandling.processors.subscribing.SubscribingEventProcessorsConfigurer;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;

public class EventProcessingConfigurer {
    private final MessagingConfigurer parent;
    private final PooledStreamingEventProcessorsConfigurer pooledStreamingEventProcessors;
    private final SubscribingEventProcessorsConfigurer subscribingEventProcessors;
    private EventProcessorCustomization processorsDefaultCustomization = EventProcessorCustomization.noOp();

    @Internal
    public EventProcessingConfigurer(@Nonnull MessagingConfigurer parent) {
        this.parent = Objects.requireNonNull(parent, "parent may not be null");
        this.pooledStreamingEventProcessors = new PooledStreamingEventProcessorsConfigurer(this);
        this.subscribingEventProcessors = new SubscribingEventProcessorsConfigurer(this);
    }

    public void build() {
        this.componentRegistry(cr -> cr.registerComponent(EventProcessorCustomization.class, cfg -> EventProcessorCustomization.noOp().andThen((axonConfig, processorConfig) -> processorConfig.unitOfWorkFactory(cfg.getComponent(UnitOfWorkFactory.class))).andThen(this.processorsDefaultCustomization)));
        this.pooledStreamingEventProcessors.build();
        this.subscribingEventProcessors.build();
    }

    public EventProcessingConfigurer defaults(@Nonnull BiFunction<Configuration, EventProcessorConfiguration, EventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults may not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen(configureDefaults::apply);
        return this;
    }

    public EventProcessingConfigurer defaults(@Nonnull UnaryOperator<EventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults may not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen((axonConfig, pConfig) -> (EventProcessorConfiguration)configureDefaults.apply((EventProcessorConfiguration)pConfig));
        return this;
    }

    public EventProcessingConfigurer pooledStreaming(@Nonnull UnaryOperator<PooledStreamingEventProcessorsConfigurer> processorsModuleTask) {
        Objects.requireNonNull(processorsModuleTask, "processorsModuleTask may not be null");
        processorsModuleTask.apply(this.pooledStreamingEventProcessors);
        return this;
    }

    public EventProcessingConfigurer subscribing(@Nonnull UnaryOperator<SubscribingEventProcessorsConfigurer> processorsModuleTask) {
        Objects.requireNonNull(processorsModuleTask, "processorsModuleTask may not be null");
        processorsModuleTask.apply(this.subscribingEventProcessors);
        return this;
    }

    public EventProcessingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        Objects.requireNonNull(componentRegistrar, "componentRegistrar may not be null");
        this.parent.componentRegistry((Consumer)componentRegistrar);
        return this;
    }
}

