/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.eventhandling.processors.EventProcessor;
import org.axonframework.eventhandling.processors.streaming.segmenting.EventTrackerStatus;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventstreaming.TrackingTokenSource;

public interface StreamingEventProcessor
extends EventProcessor {
    public String getTokenStoreIdentifier();

    public CompletableFuture<Void> releaseSegment(int var1);

    public CompletableFuture<Void> releaseSegment(int var1, long var2, TimeUnit var4);

    default public CompletableFuture<Boolean> claimSegment(int segmentId) {
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<Boolean> splitSegment(int var1);

    public CompletableFuture<Boolean> mergeSegment(int var1);

    public boolean supportsReset();

    public CompletableFuture<Void> resetTokens();

    public <R> CompletableFuture<Void> resetTokens(@Nullable R var1);

    public CompletableFuture<Void> resetTokens(@Nonnull Function<TrackingTokenSource, CompletableFuture<TrackingToken>> var1);

    public <R> CompletableFuture<Void> resetTokens(@Nonnull Function<TrackingTokenSource, CompletableFuture<TrackingToken>> var1, @Nullable R var2);

    default public CompletableFuture<Void> resetTokens(@Nonnull TrackingToken startPosition) {
        return this.resetTokens(startPosition, null);
    }

    public <R> CompletableFuture<Void> resetTokens(@Nonnull TrackingToken var1, @Nullable R var2);

    public int maxCapacity();

    public Map<Integer, EventTrackerStatus> processingStatus();

    default public boolean isReplaying() {
        return this.processingStatus().values().stream().anyMatch(trackerStatus -> !trackerStatus.isCaughtUp() && trackerStatus.isReplaying());
    }
}

