/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.segmenting;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.segmenting.Segment;
import org.axonframework.eventhandling.sequencing.SequencingPolicy;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class SegmentMatcher {
    private final SequencingPolicy sequencingPolicy;

    public SegmentMatcher(@Nonnull SequencingPolicy sequencingPolicy) {
        Objects.requireNonNull(sequencingPolicy, "SequencingPolicy may not be null");
        this.sequencingPolicy = sequencingPolicy;
    }

    public boolean matches(@Nonnull Segment segment, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(segment, "Segment may not be null");
        Objects.requireNonNull(event, "EventMessage may not be null");
        return segment.matches(Objects.hashCode(this.sequenceIdentifier(event, context)));
    }

    public Object sequenceIdentifier(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(event, "EventMessage may not be null");
        return this.sequencingPolicy.getSequenceIdentifierFor(event, context).orElseGet(event::identifier);
    }
}

