/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token.store.inmemory;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.processors.streaming.token.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.processors.streaming.token.store.TokenStore;
import org.axonframework.eventhandling.processors.streaming.token.store.UnableToClaimTokenException;
import org.axonframework.eventhandling.processors.streaming.token.store.UnableToInitializeTokenException;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final GlobalSequenceTrackingToken NULL_TOKEN = new GlobalSequenceTrackingToken(-1L);
    private final Map<ProcessAndSegment, TrackingToken> tokens = new ConcurrentHashMap<ProcessAndSegment, TrackingToken>();
    private final String identifier = UUID.randomUUID().toString();

    public InMemoryTokenStore() {
        logger.warn("An in memory token store is being created.\nThis means the event processor using this token store might process the same events again when the application is restarted.\nIf the use of an in memory token store is intentional, this warning can be ignored.\nIf the tokens should be persisted, use the JPA, JDBC or MongoDB token store instead.\n");
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> initializeTokenSegments(@Nonnull String processorName, int segmentCount, @Nullable TrackingToken initialToken, @Nullable ProcessingContext context) throws UnableToClaimTokenException {
        return this.fetchSegments(processorName, context).thenAccept(segments -> {
            if (((int[])segments).length > 0) {
                throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
            }
            for (int segment = 0; segment < segmentCount; ++segment) {
                this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(initialToken, NULL_TOKEN));
            }
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> storeToken(@Nullable TrackingToken token, @Nonnull String processorName, int segment, @Nullable ProcessingContext context) {
        Objects.requireNonNull(context, "processingContext may not be null for an InMemoryTokenStore");
        if (context.isStarted()) {
            context.runOnAfterCommit(c -> this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN)));
        } else {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN));
        }
        return FutureUtils.emptyCompletedFuture();
    }

    @Override
    @Nonnull
    public CompletableFuture<TrackingToken> fetchToken(@Nonnull String processorName, int segment, @Nullable ProcessingContext context) {
        TrackingToken trackingToken = this.tokens.get(new ProcessAndSegment(processorName, segment));
        if (trackingToken == null) {
            throw new UnableToClaimTokenException("No token was initialized for segment " + segment + " for processor " + processorName);
        }
        if (NULL_TOKEN == trackingToken) {
            return FutureUtils.emptyCompletedFuture();
        }
        return CompletableFuture.completedFuture(trackingToken);
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> releaseClaim(@Nonnull String processorName, int segment, @Nullable ProcessingContext context) {
        return FutureUtils.emptyCompletedFuture();
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> deleteToken(@Nonnull String processorName, int segment, @Nullable ProcessingContext context) throws UnableToClaimTokenException {
        this.tokens.remove(new ProcessAndSegment(processorName, segment));
        return FutureUtils.emptyCompletedFuture();
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> initializeSegment(@Nullable TrackingToken token, @Nonnull String processorName, int segment, @Nullable ProcessingContext context) throws UnableToInitializeTokenException {
        TrackingToken previous = this.tokens.putIfAbsent(new ProcessAndSegment(processorName, segment), token == null ? NULL_TOKEN : token);
        if (previous != null) {
            throw new UnableToInitializeTokenException("Token was already present");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @Nonnull
    public CompletableFuture<int[]> fetchSegments(@Nonnull String processorName, @Nullable ProcessingContext context) {
        return CompletableFuture.completedFuture(this.tokens.keySet().stream().filter(ps -> ps.processorName.equals(processorName)).map(ProcessAndSegment::getSegment).distinct().mapToInt(Number::intValue).sorted().toArray());
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<String>> retrieveStorageIdentifier(@Nullable ProcessingContext context) {
        return CompletableFuture.completedFuture(Optional.of(this.identifier));
    }

    private static class ProcessAndSegment {
        private final String processorName;
        private final int segment;

        public ProcessAndSegment(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public int getSegment() {
            return this.segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessAndSegment that = (ProcessAndSegment)o;
            return this.segment == that.segment && Objects.equals(this.processorName, that.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

