/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token.store.jpa;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Lob;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;

@Entity
@IdClass(value=PK.class)
public class TokenEntry {
    public static Clock clock = Clock.systemUTC();
    @Lob
    @Column(length=10000)
    private byte[] token;
    @Basic
    private String tokenType;
    @Basic(optional=false)
    private String timestamp;
    @Basic
    private String owner;
    @Id
    private String processorName;
    @Id
    private int segment;

    public TokenEntry(String processorName, int segment, TrackingToken token, Serializer serializer) {
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        if (token != null) {
            SerializedObject<byte[]> serializedToken = serializer.serialize(token, byte[].class);
            this.token = serializedToken.getData();
            this.tokenType = serializedToken.getType().getName();
        }
        this.processorName = processorName;
        this.segment = segment;
    }

    protected TokenEntry() {
    }

    public SerializedObject<byte[]> getSerializedToken() {
        if (this.token == null) {
            return null;
        }
        return new SimpleSerializedObject<byte[]>(this.token, byte[].class, this.getTokenType());
    }

    public TrackingToken getToken(Serializer serializer) {
        return this.token == null ? null : (TrackingToken)serializer.deserialize(this.getSerializedToken());
    }

    public SerializedType getTokenType() {
        return this.tokenType != null ? new SimpleSerializedType(this.tokenType, null) : null;
    }

    public boolean claim(String owner, TemporalAmount claimTimeout) {
        if (!this.mayClaim(owner, claimTimeout)) {
            return false;
        }
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        this.owner = owner;
        return true;
    }

    public boolean mayClaim(String owner, TemporalAmount claimTimeout) {
        return this.owner == null || owner.equals(this.owner) || this.expired(claimTimeout);
    }

    private boolean expired(TemporalAmount claimTimeout) {
        return this.timestamp().plus(claimTimeout).isBefore(clock.instant());
    }

    public boolean releaseClaim(String owner) {
        if (Objects.equals(this.owner, owner)) {
            this.owner = null;
            this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        }
        return this.owner == null;
    }

    public String timestampAsString() {
        return this.timestamp;
    }

    public Instant timestamp() {
        return DateTimeUtils.parseInstant(this.timestamp);
    }

    public void updateToken(TrackingToken token, Serializer serializer) {
        SerializedObject<byte[]> serializedToken = serializer.serialize(token, byte[].class);
        this.token = serializedToken.getData();
        this.tokenType = serializedToken.getType().getName();
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
    }

    public String getOwner() {
        return this.owner;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public int getSegment() {
        return this.segment;
    }

    public static class PK {
        private String processorName;
        private int segment;

        public PK() {
        }

        public PK(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.segment == pk.segment && Objects.equals(this.processorName, pk.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

