/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.subscribing;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.axonframework.common.annotations.Internal;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.eventhandling.configuration.EventHandlingComponentsConfigurer;
import org.axonframework.eventhandling.configuration.EventProcessingConfigurer;
import org.axonframework.eventhandling.configuration.EventProcessorModule;
import org.axonframework.eventhandling.processors.subscribing.SubscribingEventProcessorConfiguration;
import org.axonframework.eventhandling.processors.subscribing.SubscribingEventProcessorModule;
import org.axonframework.messaging.SubscribableMessageSource;

public class SubscribingEventProcessorsConfigurer {
    private final EventProcessingConfigurer parent;
    private SubscribingEventProcessorModule.Customization processorsDefaultCustomization = SubscribingEventProcessorModule.Customization.noOp();
    private final List<ModuleBuilder<SubscribingEventProcessorModule>> moduleBuilders = new ArrayList<ModuleBuilder<SubscribingEventProcessorModule>>();

    @Internal
    public SubscribingEventProcessorsConfigurer(@Nonnull EventProcessingConfigurer parent) {
        this.parent = parent;
    }

    @Internal
    public void build() {
        this.componentRegistry(cr -> cr.registerComponent(SubscribingEventProcessorModule.Customization.class, cfg -> SubscribingEventProcessorModule.Customization.noOp().andThen((axonConfig, processorConfig) -> {
            cfg.getOptionalComponent(SubscribableMessageSource.class).ifPresent(processorConfig::messageSource);
            return processorConfig;
        }).andThen(this.processorsDefaultCustomization)));
        this.moduleBuilders.forEach(moduleBuilder -> this.componentRegistry(cr -> cr.registerModule((Module)moduleBuilder.build())));
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer defaults(@Nonnull BiFunction<Configuration, SubscribingEventProcessorConfiguration, SubscribingEventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults may not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen(configureDefaults::apply);
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer defaults(@Nonnull UnaryOperator<SubscribingEventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults may not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen((axonConfig, pConfig) -> (SubscribingEventProcessorConfiguration)configureDefaults.apply((SubscribingEventProcessorConfiguration)pConfig));
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer defaultProcessor(@Nonnull String name, @Nonnull Function<EventHandlingComponentsConfigurer.RequiredComponentPhase, EventHandlingComponentsConfigurer.CompletePhase> eventHandlingComponentsBuilder) {
        this.processor(() -> EventProcessorModule.subscribing(name).eventHandlingComponents(eventHandlingComponentsBuilder).notCustomized().build());
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer processor(@Nonnull String name, @Nonnull Function<EventProcessorModule.EventHandlingPhase<SubscribingEventProcessorModule, SubscribingEventProcessorConfiguration>, SubscribingEventProcessorModule> moduleCustomizer) {
        this.processor(() -> ((SubscribingEventProcessorModule)moduleCustomizer.apply(EventProcessorModule.subscribing(name))).build());
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer processor(@Nonnull ModuleBuilder<SubscribingEventProcessorModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "moduleBuilder may not be null");
        this.moduleBuilders.add(moduleBuilder);
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorsConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> registryAction) {
        Objects.requireNonNull(registryAction, "registryAction may not be null");
        this.parent.componentRegistry(registryAction);
        return this;
    }
}

