/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tracing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.eventhandling.DelegatingEventHandlingComponent;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanScope;

public class TracingEventHandlingComponent
extends DelegatingEventHandlingComponent {
    private final Function<EventMessage, Span> spanProvider;

    public TracingEventHandlingComponent(@Nonnull Function<EventMessage, Span> spanProvider, @Nonnull EventHandlingComponent delegate) {
        super(delegate);
        this.spanProvider = Objects.requireNonNull(spanProvider, "Span provider may not be null");
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        Span span = this.spanProvider.apply(event);
        span.start();
        SpanScope ignored = span.makeCurrent();
        try {
            MessageStream.Single single = this.delegate.handle(event, context).whenComplete(span::end).onErrorContinue(ex -> {
                span.recordException((Throwable)ex);
                span.end();
                return MessageStream.failed(ex);
            }).ignoreEntries().cast();
            if (ignored != null) {
                ignored.close();
            }
            return single;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                span.recordException(e);
                span.end();
                return MessageStream.failed(e);
            }
        }
    }
}

