/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.eventstreaming.AnyEvent;
import org.axonframework.eventstreaming.EventCriteria;
import org.axonframework.eventstreaming.EventCriterion;
import org.axonframework.eventstreaming.EventTypeRestrictableOrEventCriteria;
import org.axonframework.eventstreaming.Tag;
import org.axonframework.messaging.QualifiedName;

sealed class OrEventCriteria
implements EventCriteria
permits EventTypeRestrictableOrEventCriteria {
    private final Set<EventCriteria> criteria = new HashSet<EventCriteria>();

    OrEventCriteria(Set<EventCriteria> criteria) {
        for (EventCriteria c : criteria) {
            if (c instanceof OrEventCriteria) {
                OrEventCriteria orEventCriteria = (OrEventCriteria)c;
                this.criteria.addAll(orEventCriteria.criteria);
                continue;
            }
            this.criteria.add(c);
        }
    }

    @Override
    public Set<EventCriterion> flatten() {
        return this.criteria.stream().flatMap(c -> c.flatten().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean matches(@Nonnull QualifiedName type, @Nonnull Set<Tag> tags) {
        return this.criteria.stream().anyMatch(criteria -> criteria.matches(type, tags));
    }

    @Override
    public EventCriteria or(EventCriteria criteria) {
        if (criteria instanceof AnyEvent) {
            return criteria;
        }
        return new OrEventCriteria(Set.of(this, criteria));
    }

    @Override
    public boolean hasCriteria() {
        return this.criteria.stream().anyMatch(EventCriteria::hasCriteria);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OrEventCriteria) {
            OrEventCriteria orEventCriteria = (OrEventCriteria)obj;
            return Objects.equals(this.criteria, orEventCriteria.criteria);
        }
        return false;
    }

    public String toString() {
        return "OrEventCriteria[criteria=" + String.valueOf(this.criteria) + "]";
    }

    public Set<EventCriteria> criteria() {
        return this.criteria;
    }

    public int hashCode() {
        return Objects.hash(this.criteria);
    }
}

