/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;

public abstract class AbstractMessage
implements Message {
    private final String identifier;
    private final MessageType type;

    public AbstractMessage(@Nonnull String identifier, @Nonnull MessageType type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Override
    @Nonnull
    public Message withMetadata(@Nonnull Map<String, String> metadata) {
        if (this.metadata().equals(metadata)) {
            return this;
        }
        return this.withMetadata(Metadata.from(metadata));
    }

    @Override
    @Nonnull
    public Message andMetadata(@Nonnull Map<String, String> metadata) {
        if (metadata.isEmpty()) {
            return this;
        }
        return this.withMetadata(this.metadata().mergedWith(metadata));
    }

    protected abstract Message withMetadata(Metadata var1);
}

