/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;

public class HierarchicalMessageTypeResolver
implements MessageTypeResolver {
    private final MessageTypeResolver primary;
    private final MessageTypeResolver secondary;

    public HierarchicalMessageTypeResolver(@Nonnull MessageTypeResolver primary, @Nonnull MessageTypeResolver secondary) {
        Objects.requireNonNull(primary, "Primary may not be null.");
        Objects.requireNonNull(secondary, "Fallback may not be null.");
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public Optional<MessageType> resolve(@Nonnull Class<?> payloadType) {
        return this.primary.resolve(payloadType).or(() -> this.secondary.resolve(payloadType));
    }
}

