/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Optional;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class IteratorMessageStream<M extends Message>
implements MessageStream<M> {
    private final Iterator<? extends MessageStream.Entry<M>> source;
    private MessageStream.Entry<M> peeked = null;

    IteratorMessageStream(@Nonnull Iterator<? extends MessageStream.Entry<M>> source) {
        this.source = source;
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        if (this.peeked != null) {
            MessageStream.Entry<M> result = this.peeked;
            this.peeked = null;
            return Optional.of(result);
        }
        if (this.source.hasNext()) {
            return Optional.of(this.source.next());
        }
        return Optional.empty();
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        if (this.peeked != null) {
            return Optional.of(this.peeked);
        }
        if (this.source.hasNext()) {
            this.peeked = this.source.next();
            return Optional.of(this.peeked);
        }
        return Optional.empty();
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        callback.run();
    }

    @Override
    public Optional<Throwable> error() {
        return Optional.empty();
    }

    @Override
    public boolean isCompleted() {
        return this.peeked == null && !this.source.hasNext();
    }

    @Override
    public boolean hasNextAvailable() {
        return this.peeked != null || this.source.hasNext();
    }

    @Override
    public void close() {
    }
}

