/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.messaging.DelegatingMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class MappedMessageStream<DM extends Message, RM extends Message>
extends DelegatingMessageStream<DM, RM> {
    private final Function<MessageStream.Entry<DM>, MessageStream.Entry<RM>> mapper;
    private final MessageStream<DM> delegate;

    MappedMessageStream(@Nonnull MessageStream<DM> delegate, @Nonnull Function<MessageStream.Entry<DM>, MessageStream.Entry<RM>> mapper) {
        super(delegate);
        this.delegate = delegate;
        this.mapper = mapper;
    }

    @Override
    public Optional<MessageStream.Entry<RM>> next() {
        return this.delegate.next().map(this.mapper);
    }

    @Override
    public Optional<MessageStream.Entry<RM>> peek() {
        return this.delegate.peek().map(this.mapper);
    }

    static class Single<DM extends Message, RM extends Message>
    extends MappedMessageStream<DM, RM>
    implements MessageStream.Single<RM> {
        Single(@Nonnull MessageStream.Single<DM> delegate, @Nonnull Function<MessageStream.Entry<DM>, MessageStream.Entry<RM>> mapper) {
            super(delegate, mapper);
        }
    }
}

