/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.annotations.ChainedMessageHandlerInterceptorMember;
import org.axonframework.messaging.annotations.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotations.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotations.HandlerComparator;
import org.axonframework.messaging.annotations.HandlerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.MessageStreamResolverUtils;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.interceptors.annotations.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.interceptors.annotations.MessageInterceptingMember;
import org.axonframework.messaging.interceptors.annotations.NoMoreInterceptors;

public class AnnotatedHandlerInspector<T> {
    private final Class<T> inspectedType;
    private final ParameterResolverFactory parameterResolverFactory;
    private final Map<Class<?>, AnnotatedHandlerInspector<?>> registry;
    private final List<AnnotatedHandlerInspector<? super T>> superClassInspectors;
    private final List<AnnotatedHandlerInspector<? extends T>> subClassInspectors;
    private final Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> handlers;
    private final HandlerDefinition handlerDefinition;
    private final Map<Class<?>, MessageHandlerInterceptorMemberChain<T>> interceptorChains;
    private final Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> interceptors;

    private AnnotatedHandlerInspector(Class<T> inspectedType, List<AnnotatedHandlerInspector<? super T>> superClassInspectors, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector<?>> registry, List<AnnotatedHandlerInspector<? extends T>> subClassInspectors) {
        this.inspectedType = inspectedType;
        this.parameterResolverFactory = parameterResolverFactory;
        this.registry = registry;
        this.superClassInspectors = new ArrayList<AnnotatedHandlerInspector<T>>(superClassInspectors);
        this.handlers = new HashMap();
        this.handlerDefinition = handlerDefinition;
        this.subClassInspectors = subClassInspectors;
        this.interceptorChains = new ConcurrentHashMap();
        this.interceptors = new ConcurrentHashMap();
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<T> handlerType) {
        return AnnotatedHandlerInspector.inspectType(handlerType, ClasspathParameterResolverFactory.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<T> handlerType, ParameterResolverFactory parameterResolverFactory) {
        return AnnotatedHandlerInspector.inspectType(handlerType, parameterResolverFactory, ClasspathHandlerDefinition.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<T> handlerType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return AnnotatedHandlerInspector.inspectType(handlerType, parameterResolverFactory, handlerDefinition, Collections.emptySet());
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<T> handlerType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Set<Class<? extends T>> declaredSubtypes) {
        return AnnotatedHandlerInspector.createInspector(handlerType, parameterResolverFactory, handlerDefinition, new HashMap(), declaredSubtypes);
    }

    private static <T> AnnotatedHandlerInspector<T> createInspector(Class<T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector<?>> registry, Set<Class<? extends T>> declaredSubtypes) {
        if (!registry.containsKey(inspectedType)) {
            registry.put(inspectedType, AnnotatedHandlerInspector.initialize(inspectedType, parameterResolverFactory, handlerDefinition, registry, declaredSubtypes));
        }
        return registry.get(inspectedType);
    }

    private static <T> AnnotatedHandlerInspector<T> initialize(Class<T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector<?>> registry, Set<Class<? extends T>> declaredSubtypes) {
        ArrayList<AnnotatedHandlerInspector<T>> parents = new ArrayList<AnnotatedHandlerInspector<T>>();
        Class<?>[] classArray = inspectedType.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> iFace;
            Class<?> castIF = iFace = classArray[i];
            parents.add(AnnotatedHandlerInspector.createInspector(castIF, parameterResolverFactory, handlerDefinition, registry, Collections.emptySet()));
        }
        if (inspectedType.getSuperclass() != null && !Object.class.equals(inspectedType.getSuperclass())) {
            parents.add(AnnotatedHandlerInspector.createInspector(inspectedType.getSuperclass(), parameterResolverFactory, handlerDefinition, registry, Collections.emptySet()));
        }
        List<AnnotatedHandlerInspector<? extends T>> children = declaredSubtypes.stream().map(subclass -> AnnotatedHandlerInspector.createInspector(subclass, parameterResolverFactory, handlerDefinition, registry, Collections.emptySet())).collect(Collectors.toList());
        AnnotatedHandlerInspector<T> inspector = new AnnotatedHandlerInspector<T>(inspectedType, parents, parameterResolverFactory, handlerDefinition, registry, children);
        inspector.initializeMessageHandlers(parameterResolverFactory, handlerDefinition);
        return inspector;
    }

    private void initializeMessageHandlers(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.handlers.put(this.inspectedType, new TreeSet(HandlerComparator.instance()));
        for (Method method : this.inspectedType.getDeclaredMethods()) {
            handlerDefinition.createHandler(this.inspectedType, method, parameterResolverFactory, result -> MessageStreamResolverUtils.resolveToStream(result, new ClassBasedMessageTypeResolver())).ifPresent(h -> this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h));
        }
        this.subClassInspectors.forEach(sci -> sci.getAllHandlers().forEach((key, value) -> value.forEach(h -> this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h))));
        this.superClassInspectors.forEach(sci -> sci.getAllHandlers().forEach((key, value) -> value.forEach(h -> {
            boolean isAbstract = h.unwrap(Executable.class).map(e -> Modifier.isAbstract(e.getModifiers())).orElse(false);
            if (!isAbstract) {
                this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h);
            }
            this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h);
        })));
        this.subClassInspectors.forEach(sci -> sci.getAllInterceptors().forEach((key, value) -> value.forEach(h -> this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h))));
        this.superClassInspectors.forEach(sci -> sci.getAllInterceptors().forEach((key, value) -> value.forEach(h -> {
            this.registerHandler((Class<?>)key, (MessageHandlingMember<? super T>)h);
            this.registerHandler(this.inspectedType, (MessageHandlingMember<? super T>)h);
        })));
    }

    private void registerHandler(Class<?> type, MessageHandlingMember<? super T> handler) {
        if (handler.unwrap(MessageInterceptingMember.class).isPresent()) {
            this.interceptors.computeIfAbsent(type, t -> new TreeSet(HandlerComparator.instance())).add(handler);
        } else {
            this.handlers.computeIfAbsent(type, t -> new TreeSet(HandlerComparator.instance())).add(handler);
        }
    }

    public <C> AnnotatedHandlerInspector<C> inspect(Class<C> entityType) {
        return AnnotatedHandlerInspector.createInspector(entityType, this.parameterResolverFactory, this.handlerDefinition, this.registry, Collections.emptySet());
    }

    public Stream<MessageHandlingMember<? super T>> getHandlers(Class<?> type) {
        return this.handlers.getOrDefault(type, Collections.emptySortedSet()).stream();
    }

    public MessageHandlerInterceptorMemberChain<T> chainedInterceptor(Class<?> type) {
        return this.interceptorChains.computeIfAbsent(type, t -> {
            Collection i = this.interceptors.getOrDefault(type, Collections.emptySortedSet());
            if (i.isEmpty()) {
                return NoMoreInterceptors.instance();
            }
            return new ChainedMessageHandlerInterceptorMember((Class<?>)t, i.iterator());
        });
    }

    public Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> getAllHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public Map<Class<?>, SortedSet<MessageHandlingMember<? super T>>> getAllInterceptors() {
        return Collections.unmodifiableMap(this.interceptors);
    }

    public Set<Class<?>> getAllInspectedTypes() {
        HashSet<Class<T>> inspectedTypes = new HashSet<Class<T>>();
        inspectedTypes.add(this.inspectedType);
        this.subClassInspectors.stream().map(AnnotatedHandlerInspector::getAllInspectedTypes).forEach(inspectedTypes::addAll);
        this.superClassInspectors.stream().map(AnnotatedHandlerInspector::getAllInspectedTypes).forEach(inspectedTypes::addAll);
        return Collections.unmodifiableSet(inspectedTypes);
    }
}

