/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class MessageOriginProvider
implements CorrelationDataProvider {
    public static final String DEFAULT_CORRELATION_KEY = "correlationId";
    public static final String DEFAULT_TRACE_KEY = "traceId";
    private final String correlationKey;
    private final String traceKey;

    public MessageOriginProvider() {
        this(DEFAULT_CORRELATION_KEY, DEFAULT_TRACE_KEY);
    }

    public MessageOriginProvider(@Nonnull String correlationKey, @Nonnull String traceKey) {
        this.correlationKey = Objects.requireNonNull(correlationKey, "Correlation key must not be null.");
        this.traceKey = Objects.requireNonNull(traceKey, "Trace key must not be null.");
    }

    @Override
    @Nonnull
    public Map<String, String> correlationDataFor(@Nonnull Message message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.correlationKey, message.identifier());
        result.put(this.traceKey, message.metadata().getOrDefault(this.traceKey, message.identifier()));
        return result;
    }
}

