/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class SimpleCorrelationDataProvider
implements CorrelationDataProvider {
    private final String[] headerNames;

    public SimpleCorrelationDataProvider(String ... metadataKeys) {
        this.headerNames = Arrays.copyOf(metadataKeys, metadataKeys.length);
    }

    @Override
    @Nonnull
    public Map<String, String> correlationDataFor(@Nonnull Message message) {
        if (this.headerNames.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        Metadata metadata = message.metadata();
        for (String headerName : this.headerNames) {
            if (!metadata.containsKey(headerName)) continue;
            data.put(headerName, metadata.get(headerName));
        }
        return data;
    }
}

