/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.retry;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class NonTransientExceptionClassesPredicate
implements Predicate<Throwable> {
    private final List<Class<? extends Throwable>> nonTransientFailures;

    @SafeVarargs
    public NonTransientExceptionClassesPredicate(Class<? extends Throwable> ... nonTransientFailures) {
        this.nonTransientFailures = Arrays.asList(nonTransientFailures);
    }

    @Override
    public boolean test(Throwable failure) {
        return this.isNonTransientFailure(failure);
    }

    protected boolean isNonTransientFailure(Throwable failure) {
        boolean isNonTransientFailure = this.getNonTransientFailures().stream().anyMatch(nonTransientFailure -> nonTransientFailure.isAssignableFrom(failure.getClass()));
        return isNonTransientFailure;
    }

    protected List<Class<? extends Throwable>> getNonTransientFailures() {
        return this.nonTransientFailures;
    }
}

