/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="5.0.0", forRemoval=true)
public abstract class AbstractLegacyUnitOfWork<T extends Message>
implements LegacyUnitOfWork<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLegacyUnitOfWork.class);
    private final Map<String, Object> resources = new HashMap<String, Object>();
    private final Collection<CorrelationDataProvider> correlationDataProviders = new LinkedHashSet<CorrelationDataProvider>();
    private LegacyUnitOfWork<?> parentUnitOfWork;
    private LegacyUnitOfWork.Phase phase = LegacyUnitOfWork.Phase.NOT_STARTED;
    private boolean rolledBack;

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting Unit Of Work");
        }
        Assert.state(LegacyUnitOfWork.Phase.NOT_STARTED.equals((Object)this.phase()), () -> "UnitOfWork is already started");
        this.rolledBack = false;
        this.onRollback(u -> {
            this.rolledBack = true;
        });
        CurrentUnitOfWork.ifStarted(parent -> {
            this.parentUnitOfWork = parent;
            this.root().onCleanup(r -> this.changePhase(LegacyUnitOfWork.Phase.CLEANUP, LegacyUnitOfWork.Phase.CLOSED));
        });
        this.changePhase(LegacyUnitOfWork.Phase.STARTED);
        CurrentUnitOfWork.set(this);
    }

    @Override
    public void commit() {
        if (logger.isDebugEnabled()) {
            logger.debug("Committing Unit Of Work");
        }
        Assert.state(this.phase() == LegacyUnitOfWork.Phase.STARTED, () -> String.format("The UnitOfWork is in an incompatible phase: %s", new Object[]{this.phase()}));
        Assert.state(this.isCurrent(), () -> "The UnitOfWork is not the current Unit of Work");
        try {
            if (this.isRoot()) {
                this.commitAsRoot();
            } else {
                this.commitAsNested();
            }
        }
        finally {
            CurrentUnitOfWork.clear(this);
        }
    }

    private void commitAsRoot() {
        try {
            try {
                this.changePhase(LegacyUnitOfWork.Phase.PREPARE_COMMIT, LegacyUnitOfWork.Phase.COMMIT);
            }
            catch (Exception e) {
                this.setRollbackCause(e);
                this.changePhase(LegacyUnitOfWork.Phase.ROLLBACK);
                throw e;
            }
            if (this.phase() == LegacyUnitOfWork.Phase.COMMIT) {
                this.changePhase(LegacyUnitOfWork.Phase.AFTER_COMMIT);
            }
        }
        catch (Throwable throwable) {
            this.changePhase(LegacyUnitOfWork.Phase.CLEANUP, LegacyUnitOfWork.Phase.CLOSED);
            throw throwable;
        }
        this.changePhase(LegacyUnitOfWork.Phase.CLEANUP, LegacyUnitOfWork.Phase.CLOSED);
    }

    private void commitAsNested() {
        try {
            this.changePhase(LegacyUnitOfWork.Phase.PREPARE_COMMIT, LegacyUnitOfWork.Phase.COMMIT);
            this.delegateAfterCommitToParent(this);
            this.parentUnitOfWork.onRollback(u -> this.changePhase(LegacyUnitOfWork.Phase.ROLLBACK));
        }
        catch (Exception e) {
            this.setRollbackCause(e);
            this.changePhase(LegacyUnitOfWork.Phase.ROLLBACK);
            throw e;
        }
    }

    private void delegateAfterCommitToParent(LegacyUnitOfWork<?> uow) {
        Optional<LegacyUnitOfWork<?>> parent = uow.parent();
        if (parent.isPresent()) {
            parent.get().afterCommit(this::delegateAfterCommitToParent);
        } else {
            this.changePhase(LegacyUnitOfWork.Phase.AFTER_COMMIT);
        }
    }

    @Override
    public void rollback(Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug("Rolling back Unit Of Work.", cause);
        }
        Assert.state(this.isActive() && this.phase().isBefore(LegacyUnitOfWork.Phase.ROLLBACK), () -> String.format("The UnitOfWork is in an incompatible phase: %s", new Object[]{this.phase()}));
        Assert.state(this.isCurrent(), () -> "The UnitOfWork is not the current Unit of Work");
        try {
            this.setRollbackCause(cause);
            this.changePhase(LegacyUnitOfWork.Phase.ROLLBACK);
            if (this.isRoot()) {
                this.changePhase(LegacyUnitOfWork.Phase.CLEANUP, LegacyUnitOfWork.Phase.CLOSED);
            }
        }
        finally {
            CurrentUnitOfWork.clear(this);
        }
    }

    @Override
    public Optional<LegacyUnitOfWork<?>> parent() {
        return Optional.ofNullable(this.parentUnitOfWork);
    }

    @Override
    public Map<String, Object> resources() {
        return this.resources;
    }

    @Override
    public boolean isRolledBack() {
        return this.rolledBack;
    }

    @Override
    public void registerCorrelationDataProvider(CorrelationDataProvider correlationDataProvider) {
        this.correlationDataProviders.add(correlationDataProvider);
    }

    @Override
    public Metadata getCorrelationData() {
        if (this.correlationDataProviders.isEmpty()) {
            return Metadata.emptyInstance();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (CorrelationDataProvider correlationDataProvider : this.correlationDataProviders) {
            try {
                result.putAll(correlationDataProvider.correlationDataFor((Message)this.getMessage()));
            }
            catch (Exception e) {
                logger.warn("Encountered exception creating correlation data for message with id: '{}' using correlation provider with class: '{}'will continue without as this might otherwise prevent a rollback.", new Object[]{this.getMessage().identifier(), correlationDataProvider.getClass(), e});
            }
        }
        return Metadata.from(result);
    }

    @Override
    public void onPrepareCommit(Consumer<LegacyUnitOfWork<T>> handler) {
        this.addHandler(LegacyUnitOfWork.Phase.PREPARE_COMMIT, handler);
    }

    @Override
    public void onCommit(Consumer<LegacyUnitOfWork<T>> handler) {
        this.addHandler(LegacyUnitOfWork.Phase.COMMIT, handler);
    }

    @Override
    public void afterCommit(Consumer<LegacyUnitOfWork<T>> handler) {
        this.addHandler(LegacyUnitOfWork.Phase.AFTER_COMMIT, handler);
    }

    @Override
    public void onRollback(Consumer<LegacyUnitOfWork<T>> handler) {
        this.addHandler(LegacyUnitOfWork.Phase.ROLLBACK, handler);
    }

    @Override
    public void onCleanup(Consumer<LegacyUnitOfWork<T>> handler) {
        this.addHandler(LegacyUnitOfWork.Phase.CLEANUP, handler);
    }

    @Override
    public LegacyUnitOfWork.Phase phase() {
        return this.phase;
    }

    protected void setPhase(LegacyUnitOfWork.Phase phase) {
        this.phase = phase;
    }

    protected void changePhase(LegacyUnitOfWork.Phase ... phases) {
        for (LegacyUnitOfWork.Phase phase : phases) {
            this.setPhase(phase);
            this.notifyHandlers(phase);
        }
    }

    protected Collection<CorrelationDataProvider> correlationDataProviders() {
        return this.correlationDataProviders;
    }

    protected abstract void notifyHandlers(LegacyUnitOfWork.Phase var1);

    protected abstract void addHandler(LegacyUnitOfWork.Phase var1, Consumer<LegacyUnitOfWork<T>> var2);

    protected abstract void setExecutionResult(ExecutionResult var1);

    protected abstract void setRollbackCause(Throwable var1);
}

