/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.SubscriptionQueryResponse;
import org.reactivestreams.Publisher;
import reactor.util.concurrent.Queues;

public interface QueryGateway
extends DescribableComponent {
    @Nonnull
    public <R> CompletableFuture<R> query(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    public <R> Publisher<R> streamingQuery(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, responseType, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context, int updateBufferSize) {
        SubscriptionQueryResponse<R, R> result = this.subscriptionQuery(query, responseType, responseType, context, updateBufferSize);
        return result.initialResult().concatWith(result.updates());
    }

    @Nonnull
    default public <I, U> SubscriptionQueryResponse<I, U> subscriptionQuery(@Nonnull Object query, @Nonnull Class<I> initialResponseType, @Nonnull Class<U> updateResponseType, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, initialResponseType, updateResponseType, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    public <I, U> SubscriptionQueryResponse<I, U> subscriptionQuery(@Nonnull Object var1, @Nonnull Class<I> var2, @Nonnull Class<U> var3, @Nullable ProcessingContext var4, int var5);
}

