/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;

public interface SubscriptionQueryResponse<I, U> {
    @Nonnull
    public Flux<I> initialResult();

    @Nonnull
    public Flux<U> updates();

    public void close();

    default public void handle(@Nonnull Consumer<? super I> initialResultConsumer, @Nonnull Consumer<? super U> updateConsumer, @Nonnull Consumer<Throwable> errorConsumer) {
        this.initialResult().subscribe(initialResult -> {
            try {
                initialResultConsumer.accept((I)initialResult);
                this.updates().subscribe(update -> {
                    try {
                        updateConsumer.accept((U)update);
                    }
                    catch (Exception e) {
                        this.close();
                        errorConsumer.accept(e);
                    }
                }, throwable -> {
                    this.close();
                    errorConsumer.accept((Throwable)throwable);
                });
            }
            catch (Exception e) {
                this.close();
                errorConsumer.accept(e);
            }
        }, throwable -> {
            this.close();
            errorConsumer.accept((Throwable)throwable);
        });
    }
}

