/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import reactor.core.publisher.Flux;

public final class UpdateHandler {
    private final Flux<SubscriptionQueryUpdateMessage> updates;
    private final Runnable cancelRegistration;
    private final Runnable completeHandler;

    public UpdateHandler(@Nonnull Flux<SubscriptionQueryUpdateMessage> updates, @Nonnull Runnable cancelRegistration, @Nonnull Runnable completeHandler) {
        this.updates = Objects.requireNonNull(updates, "The updates must not be null.");
        this.cancelRegistration = Objects.requireNonNull(cancelRegistration, "The cancel registration runnable must not be null.");
        this.completeHandler = Objects.requireNonNull(completeHandler, "The complete handler runnable must not be null.");
    }

    @Nonnull
    public Flux<SubscriptionQueryUpdateMessage> updates() {
        return this.updates;
    }

    public void cancel() {
        this.cancelRegistration.run();
    }

    public void complete() {
        this.completeHandler.run();
        this.cancelRegistration.run();
    }
}

