/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotations.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotations.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotations.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotations.HandlerDefinition;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.interceptors.annotations.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.QueryExecutionException;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlerName;
import org.axonframework.queryhandling.QueryHandlingComponent;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SimpleQueryHandlingComponent;
import org.axonframework.queryhandling.annotations.QueryHandlingMember;
import org.axonframework.serialization.Converter;

public class AnnotatedQueryHandlingComponent<T>
implements QueryHandlingComponent {
    private final SimpleQueryHandlingComponent handlingComponent;
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final MessageTypeResolver messageTypeResolver;
    private final MessageConverter converter;

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull MessageConverter converter) {
        this(annotatedQueryHandler, ClasspathParameterResolverFactory.forClass(annotatedQueryHandler.getClass()), converter);
    }

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageConverter converter) {
        this(annotatedQueryHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedQueryHandler.getClass()), new ClassBasedMessageTypeResolver(), converter);
    }

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter converter) {
        this.handlingComponent = SimpleQueryHandlingComponent.create("AnnotatedQueryHandlingComponent[%s]".formatted(annotatedQueryHandler.getClass().getName()));
        this.target = Objects.requireNonNull(annotatedQueryHandler, "The Annotated Query Handler may not be null.");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedQueryHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver may not be null.");
        this.converter = Objects.requireNonNull(converter, "The Converter may not be null.");
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(handler -> handler.canHandleMessageType(QueryMessage.class)).filter(handler -> handler.unwrap(QueryHandlingMember.class).isPresent()).map(handler -> handler.unwrap(QueryHandlingMember.class).get()).forEach(this::registerHandler));
    }

    private void registerHandler(QueryHandlingMember<? super T> handler) {
        Type resultType = handler.resultType();
        QualifiedName queryName = new QualifiedName(handler.queryName());
        MessageType responseType = this.messageTypeResolver.resolve((Class)resultType).orElseGet(() -> new MessageType((Class)resultType));
        this.handlingComponent.subscribe(queryName, responseType.qualifiedName(), this.constructQueryHandlerFor(handler));
    }

    private QueryHandler constructQueryHandlerFor(QueryHandlingMember<? super T> handler) {
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        return (query, context) -> {
            MessageStream<QueryResponseMessage> resultStream = interceptorChain.handle(query.withConvertedPayload((Class)handler.payloadType(), (Converter)this.converter), context, this.target, handler).mapMessage(this::asQueryResponseMessage);
            Optional<Throwable> handlingException = resultStream.error();
            if (handlingException.isPresent() && !(handlingException.get() instanceof QueryExecutionException)) {
                return MessageStream.failed(new QueryExecutionException("Handling query with identifier [" + query.identifier() + "] failed.", handlingException.get()));
            }
            return resultStream;
        };
    }

    private QueryResponseMessage asQueryResponseMessage(@Nonnull Message queryResponse) {
        return queryResponse instanceof QueryResponseMessage ? (QueryResponseMessage)queryResponse : new GenericQueryResponseMessage(queryResponse);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> handle(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
        return this.handlingComponent.handle(query, context);
    }

    @Override
    public Set<QueryHandlerName> supportedQueries() {
        return Set.copyOf(this.handlingComponent.supportedQueries());
    }
}

