/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotations.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlingComponent;
import org.axonframework.queryhandling.annotations.AnnotatedQueryHandlingComponent;
import org.axonframework.queryhandling.configuration.SimpleQueryHandlingModule;

public interface QueryHandlingModule
extends Module,
ModuleBuilder<QueryHandlingModule> {
    public static SetupPhase named(@Nonnull String moduleName) {
        return new SimpleQueryHandlingModule(moduleName);
    }

    public static interface QueryHandlerPhase
    extends ModuleBuilder<QueryHandlingModule> {
        default public QueryHandlerPhase queryHandler(@Nonnull QualifiedName queryName, @Nonnull QualifiedName responseName, @Nonnull QueryHandler queryHandler) {
            Objects.requireNonNull(queryHandler, "The query handler cannot be null.");
            return this.queryHandler(queryName, responseName, (Configuration c) -> queryHandler);
        }

        public QueryHandlerPhase queryHandler(@Nonnull QualifiedName var1, @Nonnull QualifiedName var2, @Nonnull ComponentBuilder<QueryHandler> var3);

        public QueryHandlerPhase queryHandlingComponent(@Nonnull ComponentBuilder<QueryHandlingComponent> var1);

        default public QueryHandlerPhase annotatedQueryHandlingComponent(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.queryHandlingComponent(c -> new AnnotatedQueryHandlingComponent(handlingComponentBuilder.build(c), c.getComponent(ParameterResolverFactory.class), ClasspathHandlerDefinition.forClass(c.getClass()), c.getComponent(MessageTypeResolver.class), c.getComponent(MessageConverter.class)));
        }
    }

    public static interface SetupPhase {
        public QueryHandlerPhase queryHandlers();

        default public QueryHandlerPhase queryHandlers(@Nonnull Consumer<QueryHandlerPhase> configurationLambda) {
            QueryHandlerPhase queryHandlerPhase = this.queryHandlers();
            configurationLambda.accept(queryHandlerPhase);
            return queryHandlerPhase;
        }
    }
}

