/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.SchemaStore;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.serialization.ChainingContentTypeConverter;
import org.axonframework.serialization.ConversionException;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.avro.AvroConverterConfiguration;
import org.axonframework.serialization.avro.AvroConverterStrategy;
import org.axonframework.serialization.avro.AvroConverterStrategyConfiguration;
import org.axonframework.serialization.avro.ByteArrayToGenericRecordConverter;
import org.axonframework.serialization.avro.SpecificRecordBaseConverterStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(AvroConverter.class);
    private final ChainingContentTypeConverter converter;
    private final List<AvroConverterStrategy> converterStrategies = new ArrayList<AvroConverterStrategy>();

    public AvroConverter(@Nonnull SchemaStore schemaStore, @Nonnull UnaryOperator<AvroConverterConfiguration> configurationOverride) {
        this(schemaStore, configurationOverride, new ChainingContentTypeConverter());
    }

    @Internal
    public AvroConverter(@Nonnull SchemaStore schemaStore, @Nonnull UnaryOperator<AvroConverterConfiguration> configurationOverride, @Nonnull ChainingContentTypeConverter chainingTypeConverter) {
        AvroConverterConfiguration config = (AvroConverterConfiguration)Objects.requireNonNull(configurationOverride, "the configurationOverride may not be null.").apply(new AvroConverterConfiguration(schemaStore));
        if (config.includeDefaultAvroConverterStrategies()) {
            SpecificRecordBaseConverterStrategy defaultStrategy = new SpecificRecordBaseConverterStrategy(config.schemaStore(), config.schemaIncompatibilityChecker());
            config = config.addConverterStrategy(defaultStrategy);
        }
        AvroConverterStrategyConfiguration strategyConfiguration = config.avroConverterStrategyConfiguration();
        config.strategies().forEach(strategy -> strategy.applyStrategyConfiguration(strategyConfiguration));
        this.converterStrategies.addAll(config.strategies());
        if (this.converterStrategies.isEmpty()) {
            throw new IllegalStateException("At least one converter strategy is required, but none were configured.");
        }
        this.converter = chainingTypeConverter;
        this.converter.registerConverter(new ByteArrayToGenericRecordConverter(schemaStore));
    }

    @Override
    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        if (logger.isTraceEnabled()) {
            logger.trace("Validating if we can convert from source type [{}] to target type [{}].", (Object)sourceType, (Object)targetType);
        }
        return sourceType.equals(targetType) || this.converter.canConvert(sourceType, targetType) || this.strategyForType(sourceType) && this.converter.canConvert((Type)((Object)byte[].class), targetType) || this.converter.canConvert(sourceType, (Type)((Object)byte[].class)) && this.strategyForType(targetType) || this.converter.canConvert(sourceType, (Type)((Object)GenericRecord.class)) && this.strategyForType(targetType);
    }

    private boolean strategyForType(Type type) {
        if (type instanceof Class) {
            return this.converterStrategies.stream().anyMatch(it -> it.test((Class)type));
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        if (input == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Input to convert is null, so returning null immediately.");
            }
            return null;
        }
        if (!(targetType instanceof Class)) {
            throw new ConversionException("Cannot convert input to " + String.valueOf(targetType) + ", target type must be a class.");
        }
        Class targetClass = (Class)targetType;
        Class<?> sourceClass = input.getClass();
        if (sourceClass.equals(targetClass) || targetClass.isAssignableFrom(sourceClass)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Casting given input since source and target type are identical.");
            }
            return (T)input;
        }
        if (this.strategyForType(sourceClass)) {
            if (byte[].class.equals((Object)targetType)) {
                return this.serializeByStrategy(input, sourceClass);
            }
            if (this.converter.canConvert((Type)((Object)byte[].class), targetType)) {
                return this.converter.convert(this.serializeByStrategy(input, sourceClass), targetType);
            }
            throw new ConversionException("Cannot convert given input to target type [" + String.valueOf(targetType) + "]");
        }
        if (this.strategyForType(targetClass)) {
            if (byte[].class.equals(sourceClass)) {
                return this.deserializeByStrategy((byte[])input, targetClass);
            }
            if (this.converter.canConvert(sourceClass, byte[].class)) {
                return this.deserializeByStrategy(this.converter.convert(input, byte[].class), targetClass);
            }
            if (GenericRecord.class.isAssignableFrom(sourceClass)) {
                return this.deserializeByStrategy((GenericRecord)input, targetClass);
            }
            throw new ConversionException("Cannot convert given input to target type [" + String.valueOf(targetType) + "]");
        }
        if (GenericRecord.class.equals((Object)targetType)) {
            if (this.converter.canConvert(sourceClass, GenericRecord.class)) {
                return (T)this.converter.convert(input, GenericRecord.class);
            }
            throw new ConversionException("Cannot convert given input to target type [" + String.valueOf(targetType) + "]");
        }
        throw new ConversionException("Cannot convert given input to target type [" + String.valueOf(targetType) + "]");
    }

    private <T> T serializeByStrategy(@Nonnull Object input, @Nonnull Class<?> sourceType) {
        return (T)this.converterStrategies.stream().filter(it -> it.test(sourceType)).findFirst().orElseThrow(() -> new ConversionException("Could not find converter strategy to convert from source type [" + String.valueOf(sourceType) + "]")).convertToSingleObjectEncoded(input);
    }

    private <T> T deserializeByStrategy(@Nonnull byte[] input, @Nonnull Class<?> targetType) {
        return (T)this.converterStrategies.stream().filter(it -> it.test(targetType)).findFirst().orElseThrow(() -> new ConversionException("Could not find converter strategy to convert from bytes to target type [" + String.valueOf(targetType) + "]")).convertFromSingleObjectEncoded(input, targetType);
    }

    private <T> T deserializeByStrategy(@Nonnull GenericRecord input, @Nonnull Class<?> targetType) {
        return (T)this.converterStrategies.stream().filter(it -> it.test(targetType)).findFirst().orElseThrow(() -> new ConversionException("Could not find converter strategy to convert from GenericRecord to target type [" + String.valueOf(targetType) + "]")).convertFromGenericRecord(input, targetType);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        for (AvroConverterStrategy strategy : this.converterStrategies) {
            strategy.describeTo(descriptor);
        }
    }
}

