/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.Metadata;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;
import org.axonframework.serialization.json.ByteArrayToJsonNodeConverter;
import org.axonframework.serialization.json.JsonNodeToByteArrayConverter;
import org.axonframework.serialization.json.JsonNodeToObjectNodeConverter;
import org.axonframework.serialization.json.MetadataDeserializer;
import org.axonframework.serialization.json.ObjectNodeToJsonNodeConverter;

@Deprecated(forRemoval=true, since="5.0.0")
public class JacksonSerializer
implements Serializer {
    private final RevisionResolver revisionResolver;
    private final Converter converter;
    private final ObjectMapper objectMapper;
    private final Set<String> unknownClasses = new ConcurrentSkipListSet<String>();
    private final boolean cacheUnknownClasses;

    public static Builder builder() {
        return new Builder();
    }

    public static JacksonSerializer defaultSerializer() {
        return JacksonSerializer.builder().build();
    }

    protected JacksonSerializer(Builder builder) {
        builder.validate();
        this.revisionResolver = builder.revisionResolver;
        this.converter = builder.converter;
        this.objectMapper = builder.objectMapper;
        this.objectMapper.registerModule((Module)new SimpleModule("Axon-Jackson Module").addDeserializer(Metadata.class, (JsonDeserializer)new MetadataDeserializer()));
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (this.converter instanceof ChainingContentTypeConverter) {
            this.registerConverters((ChainingContentTypeConverter)this.converter);
        }
        this.cacheUnknownClasses = builder.cacheUnknownClasses;
    }

    protected void registerConverters(ChainingContentTypeConverter converter) {
        converter.registerConverter(new JsonNodeToByteArrayConverter(this.objectMapper));
        converter.registerConverter(new ByteArrayToJsonNodeConverter(this.objectMapper));
        converter.registerConverter(new JsonNodeToObjectNodeConverter());
        converter.registerConverter(new ObjectNodeToJsonNodeConverter());
    }

    @Override
    public <T> T convert(@Nullable Object source, @Nonnull Type targetRepresentation) {
        JavaType valueType;
        if (source == null) {
            return null;
        }
        Class<?> sourceType = source.getClass();
        if (this.converter.canConvert(sourceType, (valueType = this.objectMapper.constructType(targetRepresentation)).getRawClass())) {
            return this.converter.convert(source, valueType.getRawClass());
        }
        if (this.converter.canConvert(sourceType, byte[].class)) {
            byte[] bytes = this.converter.convert(source, byte[].class);
            try {
                return (T)this.objectMapper.readValue(bytes, valueType);
            }
            catch (IOException e) {
                throw new SerializationException("Exception when trying to convert object of type '" + sourceType.getTypeName() + "' to '" + targetRepresentation.getTypeName() + "'", e);
            }
        }
        if (this.converter.canConvert(valueType.getRawClass(), byte[].class)) {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes(source);
                return this.converter.convert((Object)bytes, valueType.getRawClass());
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("Exception when trying to convert object of type '" + sourceType.getTypeName() + "' to '" + targetRepresentation.getTypeName() + "'", e);
            }
        }
        return (T)this.objectMapper.convertValue(source, valueType);
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, @Nonnull Class<T> expectedRepresentation) {
        try {
            if (String.class.equals(expectedRepresentation)) {
                return new SimpleSerializedObject<String>(this.getWriter().writeValueAsString(object), expectedRepresentation, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
            }
            byte[] serializedBytes = this.getWriter().writeValueAsBytes(object);
            T serializedContent = this.converter.convert((Object)serializedBytes, expectedRepresentation);
            return new SimpleSerializedObject<T>(serializedContent, expectedRepresentation, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Unable to serialize object", e);
        }
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected ObjectWriter getWriter() {
        return this.objectMapper.writer();
    }

    protected ObjectReader getReader(Class<?> type) {
        return this.objectMapper.readerFor(type);
    }

    @Override
    public <T> boolean canSerializeTo(@Nonnull Class<T> expectedRepresentation) {
        return JsonNode.class.equals(expectedRepresentation) || String.class.equals(expectedRepresentation) || this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(@Nonnull SerializedObject<S> serializedObject) {
        try {
            if (SerializedType.emptyType().equals(serializedObject.getType())) {
                return null;
            }
            Class type = this.classForType(serializedObject.getType());
            if (UnknownSerializedType.class.isAssignableFrom(type)) {
                return (T)new UnknownSerializedType(this, serializedObject);
            }
            if (JsonNode.class.equals(serializedObject.getContentType())) {
                return (T)this.getReader(type).readValue((JsonNode)serializedObject.getData());
            }
            SerializedObject<Object> byteSerialized = serializedObject.getContentType().equals(byte[].class) ? serializedObject : new SimpleSerializedObject<byte[]>(this.convert(serializedObject.getData(), byte[].class), byte[].class, serializedObject.getType());
            return (T)this.getReader(type).readValue((byte[])byteSerialized.getData());
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing object", e);
        }
    }

    @Override
    public Class classForType(@Nonnull SerializedType type) {
        if (SimpleSerializedType.emptyType().equals(type)) {
            return Void.class;
        }
        String className = this.resolveClassName(type);
        if (this.cacheUnknownClasses && this.unknownClasses.contains(className)) {
            return UnknownSerializedType.class;
        }
        try {
            return this.objectMapper.getTypeFactory().findClass(className);
        }
        catch (ClassNotFoundException e) {
            this.unknownClasses.add(className);
            return UnknownSerializedType.class;
        }
    }

    protected String resolveClassName(SerializedType serializedType) {
        return serializedType.getName();
    }

    @Override
    public SerializedType typeForClass(Class type) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return SimpleSerializedType.emptyType();
        }
        return new SimpleSerializedType(type.getName(), this.revisionResolver.revisionOf(type));
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    protected RevisionResolver getRevisionResolver() {
        return this.revisionResolver;
    }

    public static class Builder {
        private RevisionResolver revisionResolver = new AnnotationRevisionResolver();
        private Converter converter = new ChainingContentTypeConverter();
        private ObjectMapper objectMapper = new ObjectMapper();
        private boolean lenientDeserialization = false;
        private boolean defaultTyping = false;
        private ClassLoader classLoader;
        private boolean cacheUnknownClasses = true;

        public Builder revisionResolver(RevisionResolver revisionResolver) {
            BuilderUtils.assertNonNull(revisionResolver, "RevisionResolver may not be null");
            this.revisionResolver = revisionResolver;
            return this;
        }

        public Builder converter(Converter converter) {
            BuilderUtils.assertNonNull(converter, "Converter may not be null");
            this.converter = converter;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            BuilderUtils.assertNonNull(objectMapper, "ObjectMapper may not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            BuilderUtils.assertNonNull(classLoader, "ClassLoader may not be null");
            this.classLoader = classLoader;
            return this;
        }

        public Builder lenientDeserialization() {
            this.lenientDeserialization = true;
            return this;
        }

        public Builder disableCachingOfUnknownClasses() {
            this.cacheUnknownClasses = false;
            return this;
        }

        public Builder defaultTyping() {
            this.defaultTyping = true;
            return this;
        }

        public JacksonSerializer build() {
            if (this.lenientDeserialization) {
                this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
                this.objectMapper.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
                this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            if (this.defaultTyping) {
                this.objectMapper.activateDefaultTyping(this.objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS);
            }
            if (this.classLoader != null) {
                this.objectMapper.setTypeFactory(this.objectMapper.getTypeFactory().withClassLoader(this.classLoader));
            }
            return new JacksonSerializer(this);
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

