/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageTimerMonitor
implements MessageMonitor<Message<?>> {
    private final Timer allTimer;
    private final Timer successTimer;
    private final Timer failureTimer;
    private final Timer ignoredTimer;
    private final Clock clock;

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return MessageTimerMonitor.buildMonitor(meterNamePrefix, meterRegistry, Clock.SYSTEM);
    }

    public static MessageTimerMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Clock clock) {
        Timer allTimer = MessageTimerMonitor.buildTimer(meterNamePrefix, "allTimer", meterRegistry);
        Timer successTimer = MessageTimerMonitor.buildTimer(meterNamePrefix, "successTimer", meterRegistry);
        Timer failureTimer = MessageTimerMonitor.buildTimer(meterNamePrefix, "failureTimer", meterRegistry);
        Timer ignoredTimer = MessageTimerMonitor.buildTimer(meterNamePrefix, "ignoredTimer", meterRegistry);
        return new MessageTimerMonitor(allTimer, successTimer, failureTimer, ignoredTimer, clock);
    }

    private static Timer buildTimer(String meterNamePrefix, String timerName, MeterRegistry meterRegistry) {
        return Timer.builder((String)(meterNamePrefix + "." + timerName)).distributionStatisticExpiry(Duration.of(10L, ChronoUnit.MINUTES)).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999}).register(meterRegistry);
    }

    private MessageTimerMonitor(Timer allTimer, Timer successTimer, Timer failureTimer, Timer ignoredTimer, Clock clock) {
        this.allTimer = allTimer;
        this.successTimer = successTimer;
        this.failureTimer = failureTimer;
        this.ignoredTimer = ignoredTimer;
        this.clock = clock;
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        final long startTime = this.clock.monotonicTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                MessageTimerMonitor.this.allTimer.record(duration, TimeUnit.NANOSECONDS);
                MessageTimerMonitor.this.successTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportFailure(Throwable cause) {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                MessageTimerMonitor.this.allTimer.record(duration, TimeUnit.NANOSECONDS);
                MessageTimerMonitor.this.failureTimer.record(duration, TimeUnit.NANOSECONDS);
            }

            public void reportIgnored() {
                long duration = MessageTimerMonitor.this.clock.monotonicTime() - startTime;
                MessageTimerMonitor.this.allTimer.record(duration, TimeUnit.NANOSECONDS);
                MessageTimerMonitor.this.ignoredTimer.record(duration, TimeUnit.NANOSECONDS);
            }
        };
    }
}

