/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>> {
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Function<Message<?>, Iterable<Tag>> tagsBuilder;
    private final Clock clock;
    private final ConcurrentMap<Tags, AtomicLong> gauges = new ConcurrentHashMap<Tags, AtomicLong>();

    public static Builder builder() {
        return new Builder();
    }

    protected EventProcessorLatencyMonitor(Builder builder) {
        builder.validate();
        this.meterNamePrefix = builder.meterNamePrefix;
        this.meterRegistry = builder.meterRegistry;
        this.tagsBuilder = builder.tagsBuilder;
        this.clock = builder.clock;
    }

    @Deprecated
    public static EventProcessorLatencyMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return EventProcessorLatencyMonitor.builder().meterNamePrefix(meterNamePrefix).meterRegistry(meterRegistry).build();
    }

    @Deprecated
    public static EventProcessorLatencyMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return EventProcessorLatencyMonitor.builder().meterNamePrefix(meterNamePrefix).meterRegistry(meterRegistry).tagsBuilder(tagsBuilder).build();
    }

    public MessageMonitor.MonitorCallback onMessageIngested(EventMessage<?> message) {
        if (message != null) {
            Tags tags = Tags.of(this.tagsBuilder.apply((Message<?>)message));
            AtomicLong actualCounter = this.gauges.computeIfAbsent(tags, k -> new AtomicLong());
            actualCounter.set(this.clock.wallTime() - message.getTimestamp().toEpochMilli());
            Gauge.builder((String)(this.meterNamePrefix + ".latency"), actualCounter::get).tags((Iterable)tags).register(this.meterRegistry);
        }
        return NoOpMessageMonitorCallback.INSTANCE;
    }

    public static class Builder {
        private String meterNamePrefix;
        private MeterRegistry meterRegistry;
        private Function<Message<?>, Iterable<Tag>> tagsBuilder = message -> Tags.empty();
        private Clock clock = Clock.SYSTEM;

        public Builder meterNamePrefix(String meterNamePrefix) {
            BuilderUtils.assertNonEmpty((String)meterNamePrefix, (String)"The meter name prefix may not be null or empty");
            this.meterNamePrefix = meterNamePrefix;
            return this;
        }

        public Builder meterRegistry(MeterRegistry meterRegistry) {
            BuilderUtils.assertNonNull((Object)meterRegistry, (String)"MeterRegistry may not be null");
            this.meterRegistry = meterRegistry;
            return this;
        }

        public Builder clock(Clock clock) {
            BuilderUtils.assertNonNull((Object)clock, (String)"Clock may not be null");
            this.clock = clock;
            return this;
        }

        public Builder tagsBuilder(Function<Message<?>, Iterable<Tag>> tagsBuilder) {
            BuilderUtils.assertNonNull(tagsBuilder, (String)"TagsBuilder may not be null");
            this.tagsBuilder = tagsBuilder;
            return this;
        }

        public EventProcessorLatencyMonitor build() {
            return new EventProcessorLatencyMonitor(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty((String)this.meterNamePrefix, (String)"The meter name prefix is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.meterRegistry, (String)"The MeterRegistry is a hard requirement and should be provided");
        }
    }
}

