/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.DataSourceConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.SagaStorageException;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.modelling.saga.repository.jpa.SagaEntry;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSagaStore
implements SagaStore<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcSagaStore.class);
    private final ConnectionProvider connectionProvider;
    private final SagaSqlSchema sqlSchema;
    private Serializer serializer;

    protected JdbcSagaStore(Builder builder) {
        builder.validate();
        this.connectionProvider = builder.connectionProvider;
        this.sqlSchema = builder.sqlSchema;
        this.serializer = builder.serializer;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        EntryImpl<Object> entryImpl;
        SerializedObject<?> serializedSaga;
        Connection conn;
        ResultSet resultSet;
        PreparedStatement statement;
        block7: {
            statement = null;
            resultSet = null;
            conn = null;
            conn = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_loadSaga(conn, sagaIdentifier);
            resultSet = statement.executeQuery();
            serializedSaga = null;
            if (resultSet.next()) {
                serializedSaga = this.sqlSchema.readSerializedSaga(resultSet);
            }
            if (serializedSaga != null) break block7;
            SagaStore.Entry<S> entry = null;
            JdbcUtils.closeQuietly((Statement)statement);
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Connection)conn);
            return entry;
        }
        try {
            Object loadedSaga = this.serializer.deserialize(serializedSaga);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded saga id [{}] of type [{}]", (Object)sagaIdentifier, (Object)loadedSaga.getClass().getName());
            }
            entryImpl = new EntryImpl<Object>(this.loadAssociations(conn, this.sagaTypeName(sagaType), sagaIdentifier), loadedSaga);
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while loading a Saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)statement);
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Connection)conn);
        return entryImpl;
    }

    @Override
    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        TreeSet<String> treeSet;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_findAssocSagaIdentifiers(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType));
            resultSet = statement.executeQuery();
            TreeSet<String> result = new TreeSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            treeSet = result;
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while reading saga associations", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)statement);
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Connection)conn);
        return treeSet;
    }

    @Override
    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        PreparedStatement statement1 = null;
        PreparedStatement statement2 = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement1 = this.sqlSchema.sql_deleteAssociationEntries(conn, sagaIdentifier);
            statement2 = this.sqlSchema.sql_deleteSagaEntry(conn, sagaIdentifier);
            statement1.executeUpdate();
            statement2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to delete a saga entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement1);
                JdbcUtils.closeQuietly(statement2);
                JdbcUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)statement1);
        JdbcUtils.closeQuietly((Statement)statement2);
        JdbcUtils.closeQuietly((Connection)conn);
    }

    @Override
    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, AssociationValues associationValues) {
        int updateCount;
        SagaEntry<Object> entry = new SagaEntry<Object>(saga, sagaIdentifier, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating saga id {} as {}", (Object)sagaIdentifier, (Object)new String((byte[])entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_updateSaga(conn, entry.getSagaId(), (byte[])entry.getSerializedSaga(), entry.getSagaType(), entry.getRevision());
            updateCount = statement.executeUpdate();
            if (updateCount != 0) {
                for (AssociationValue associationValue : associationValues.addedAssociations()) {
                    JdbcUtils.closeQuietly((Statement)statement);
                    statement = this.sqlSchema.sql_storeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                    statement.executeUpdate();
                }
                for (AssociationValue associationValue : associationValues.removedAssociations()) {
                    JdbcUtils.closeQuietly((Statement)statement);
                    statement = this.sqlSchema.sql_removeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                    statement.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to update a saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)statement);
        JdbcUtils.closeQuietly((Connection)conn);
        if (updateCount == 0) {
            logger.warn("Expected to be able to update a Saga instance, but no rows were found. Inserting instead.");
            this.insertSaga(sagaType, sagaIdentifier, saga, associationValues.asSet());
        }
    }

    @Override
    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, Set<AssociationValue> associationValues) {
        SagaEntry<Object> entry = new SagaEntry<Object>(saga, sagaIdentifier, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Storing saga id {} as {}", (Object)sagaIdentifier, (Object)new String((byte[])entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_storeSaga(conn, entry.getSagaId(), entry.getRevision(), entry.getSagaType(), (byte[])entry.getSerializedSaga());
            statement.executeUpdate();
            for (AssociationValue associationValue : associationValues) {
                JdbcUtils.closeQuietly((Statement)statement);
                statement = this.sqlSchema.sql_storeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to store a Saga Entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)statement);
        JdbcUtils.closeQuietly((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AssociationValue> loadAssociations(Connection conn, String sagaTypeName, String sagaIdentifier) throws SQLException {
        Set<AssociationValue> set;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.sqlSchema.sql_findAssociations(conn, sagaIdentifier, sagaTypeName);
            resultSet = statement.executeQuery();
            set = this.sqlSchema.readAssociationValues(resultSet);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(statement);
            JdbcUtils.closeQuietly(resultSet);
            throw throwable;
        }
        JdbcUtils.closeQuietly((Statement)statement);
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        return set;
    }

    private String sagaTypeName(Class<?> sagaType) {
        return this.serializer.typeForClass(sagaType).getName();
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void createSchema() throws SQLException {
        Connection connection = this.connectionProvider.getConnection();
        try {
            this.sqlSchema.sql_createTableSagaEntry(connection).executeUpdate();
            this.sqlSchema.sql_createTableAssocValueEntry(connection).executeUpdate();
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    private static class EntryImpl<S>
    implements SagaStore.Entry<S> {
        private final Set<AssociationValue> associations;
        private final S loadedSaga;

        public EntryImpl(Set<AssociationValue> associations, S loadedSaga) {
            this.associations = associations;
            this.loadedSaga = loadedSaga;
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associations;
        }

        @Override
        public S saga() {
            return this.loadedSaga;
        }
    }

    public static class Builder {
        private ConnectionProvider connectionProvider;
        private SagaSqlSchema sqlSchema = new GenericSagaSqlSchema();
        private Serializer serializer = XStreamSerializer.builder().build();

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            BuilderUtils.assertNonNull((Object)connectionProvider, (String)"ConnectionProvider may not be null");
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder dataSource(DataSource dataSource) {
            BuilderUtils.assertNonNull((Object)dataSource, (String)"DataSource used to instantiate a ConnectionProvider may not be null");
            DataSourceConnectionProvider dataSourceConnectionProvider = new DataSourceConnectionProvider(dataSource);
            this.connectionProvider = new UnitOfWorkAwareConnectionProviderWrapper((ConnectionProvider)dataSourceConnectionProvider);
            return this;
        }

        public Builder sqlSchema(SagaSqlSchema sqlSchema) {
            BuilderUtils.assertNonNull((Object)sqlSchema, (String)"SagaSqlSchema may not be null");
            this.sqlSchema = sqlSchema;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public JdbcSagaStore build() {
            return new JdbcSagaStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.connectionProvider, (String)"The ConnectionProvider is a hard requirement and should be provided");
        }
    }
}

