/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.Assert;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NoOpLock;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.AbstractRepository;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.tracing.SpanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockingRepository<T, A extends Aggregate<T>>
extends AbstractRepository<T, LockAwareAggregate<T, A>> {
    private static final Logger logger = LoggerFactory.getLogger(LockingRepository.class);
    private final LockFactory lockFactory;

    protected LockingRepository(Builder<T> builder) {
        super(builder);
        this.lockFactory = ((Builder)builder).lockFactory;
    }

    @Override
    protected LockAwareAggregate<T, A> doCreateNew(Callable<T> factoryMethod) throws Exception {
        Supplier<Lock> lockSupplier;
        UnitOfWork unitOfWork = CurrentUnitOfWork.get();
        A aggregate = this.doCreateNewForLock(factoryMethod);
        String aggregateIdentifier = aggregate.identifierAsString();
        if (!Objects.isNull(aggregateIdentifier)) {
            Lock lock = (Lock)this.spanFactory.createObtainLockSpan(aggregateIdentifier).runSupplier(() -> this.lockFactory.obtainLock(aggregateIdentifier));
            unitOfWork.onCleanup(u -> lock.release());
            lockSupplier = () -> lock;
        } else {
            lockSupplier = ObjectUtils.sameInstanceSupplier(() -> {
                Lock lock = Objects.isNull(aggregate.identifierAsString()) ? NoOpLock.INSTANCE : this.lockFactory.obtainLock(aggregate.identifierAsString());
                unitOfWork.onCleanup(u -> lock.release());
                return lock;
            });
        }
        return new LockAwareAggregate(aggregate, lockSupplier);
    }

    protected abstract A doCreateNewForLock(Callable<T> var1) throws Exception;

    @Override
    protected LockAwareAggregate<T, A> doLoad(String aggregateIdentifier, Long expectedVersion) {
        Lock lock = (Lock)this.spanFactory.createObtainLockSpan(aggregateIdentifier).runSupplier(() -> this.lockFactory.obtainLock(aggregateIdentifier));
        try {
            A aggregate = this.doLoadWithLock(aggregateIdentifier, expectedVersion);
            CurrentUnitOfWork.get().onCleanup(u -> lock.release());
            return new LockAwareAggregate(aggregate, lock);
        }
        catch (Throwable ex) {
            logger.debug("Exception occurred while trying to load an aggregate. Releasing lock.", ex);
            lock.release();
            throw ex;
        }
    }

    @Override
    protected LockAwareAggregate<T, A> doLoadOrCreate(String aggregateIdentifier, Callable<T> factoryMethod) throws Exception {
        Lock lock = (Lock)this.spanFactory.createObtainLockSpan(aggregateIdentifier).runSupplier(() -> this.lockFactory.obtainLock(aggregateIdentifier));
        try {
            A aggregate = this.doLoadWithLock(aggregateIdentifier, null);
            CurrentUnitOfWork.get().onCleanup(u -> lock.release());
            return new LockAwareAggregate(aggregate, lock);
        }
        catch (AggregateNotFoundException ex) {
            A aggregate = this.doCreateNewForLock(factoryMethod);
            CurrentUnitOfWork.get().onCleanup(u -> lock.release());
            return new LockAwareAggregate(aggregate, lock);
        }
        catch (Throwable ex) {
            logger.debug("Exception occurred while trying to load/create an aggregate. Releasing lock.", ex);
            lock.release();
            throw ex;
        }
    }

    @Override
    protected void prepareForCommit(LockAwareAggregate<T, A> aggregate) {
        Assert.state((boolean)aggregate.isLockHeld(), () -> "An aggregate is being used for which a lock is no longer held");
        super.prepareForCommit(aggregate);
    }

    @Override
    protected void doSave(LockAwareAggregate<T, A> aggregate) {
        if (aggregate.version() != null && !aggregate.isLockHeld()) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.identifierAsString()));
        }
        this.doSaveWithLock(aggregate.getWrappedAggregate());
    }

    @Override
    protected final void doDelete(LockAwareAggregate<T, A> aggregate) {
        if (aggregate.version() != null && !aggregate.isLockHeld()) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.identifierAsString()));
        }
        this.doDeleteWithLock(aggregate.getWrappedAggregate());
    }

    protected abstract void doSaveWithLock(A var1);

    protected abstract void doDeleteWithLock(A var1);

    protected abstract A doLoadWithLock(String var1, Long var2);

    protected static abstract class Builder<T>
    extends AbstractRepository.Builder<T> {
        private LockFactory lockFactory = PessimisticLockFactory.usingDefaults();

        protected Builder(Class<T> aggregateType) {
            super(aggregateType);
        }

        @Override
        public Builder<T> parameterResolverFactory(@Nonnull ParameterResolverFactory parameterResolverFactory) {
            super.parameterResolverFactory(parameterResolverFactory);
            return this;
        }

        @Override
        public Builder<T> handlerDefinition(@Nonnull HandlerDefinition handlerDefinition) {
            super.handlerDefinition(handlerDefinition);
            return this;
        }

        @Override
        public Builder<T> aggregateModel(@Nonnull AggregateModel<T> aggregateModel) {
            super.aggregateModel(aggregateModel);
            return this;
        }

        @Override
        public Builder<T> subtypes(@Nonnull Set<Class<? extends T>> subtypes) {
            super.subtypes(subtypes);
            return this;
        }

        @Override
        public Builder<T> subtype(@Nonnull Class<? extends T> subtype) {
            super.subtype(subtype);
            return this;
        }

        @Override
        @Deprecated
        public Builder<T> spanFactory(SpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public Builder<T> lockFactory(LockFactory lockFactory) {
            BuilderUtils.assertNonNull((Object)lockFactory, (String)"LockFactory may not be null");
            this.lockFactory = lockFactory;
            return this;
        }
    }
}

