/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.saga.Saga;
import org.axonframework.modelling.saga.SagaManagerSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultSagaManagerSpanFactory
implements SagaManagerSpanFactory {
    private final SpanFactory spanFactory;
    private final String sagaIdentifierAttribute;

    protected DefaultSagaManagerSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.sagaIdentifierAttribute = builder.builderSagaIdentifierAttribute;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Span createCreateSagaInstanceSpan(EventMessage<?> event, Class<?> sagaType, String sagaIdentifier) {
        return this.spanFactory.createInternalSpan(() -> "SagaManager.createSaga(" + sagaType.getSimpleName() + ")", event).addAttribute(this.sagaIdentifierAttribute, sagaIdentifier);
    }

    @Override
    public Span createInvokeSagaSpan(EventMessage<?> event, Class<?> sagaType, Saga<?> saga) {
        return this.spanFactory.createInternalSpan(() -> "SagaManager.invokeSaga(" + sagaType.getSimpleName() + ")", event).addAttribute(this.sagaIdentifierAttribute, saga.getSagaIdentifier());
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private String builderSagaIdentifierAttribute = "axon.sagaIdentifier";

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder sagaIdentifierAttribute(String sagaIdentifierAttribute) {
            BuilderUtils.assertNonEmpty((String)sagaIdentifierAttribute, (String)"sagaIdentifierAttribute may not be null or empty");
            this.builderSagaIdentifierAttribute = sagaIdentifierAttribute;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.builderSpanFactory, (String)"spanFactory may not be null");
        }

        public DefaultSagaManagerSpanFactory build() {
            return new DefaultSagaManagerSpanFactory(this);
        }
    }
}

