/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.repository.jdbc.SagaSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;

public class GenericSagaSqlSchema
implements SagaSqlSchema {
    protected final SagaSchema sagaSchema;

    public GenericSagaSqlSchema() {
        this(new SagaSchema());
    }

    public GenericSagaSqlSchema(SagaSchema sagaSchema) {
        this.sagaSchema = sagaSchema;
    }

    @Override
    public PreparedStatement sql_loadSaga(Connection connection, String sagaId) throws SQLException {
        String sql = "SELECT " + String.join((CharSequence)", ", this.sagaSchema.serializedSagaColumn(), this.sagaSchema.sagaTypeColumn(), this.sagaSchema.revisionColumn()) + " FROM " + this.sagaSchema.sagaEntryTable() + " WHERE " + this.sagaSchema.sagaIdColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaId);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_removeAssocValue(Connection connection, String key, String value, String sagaType, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE " + this.sagaSchema.associationKeyColumn() + " = ? AND " + this.sagaSchema.associationValueColumn() + " = ? AND " + this.sagaSchema.sagaTypeColumn() + " = ? AND " + this.sagaSchema.sagaIdColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setString(4, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_storeAssocValue(Connection connection, String key, String value, String sagaType, String sagaIdentifier) throws SQLException {
        String sql = "INSERT INTO " + this.sagaSchema.associationValueEntryTable() + " (" + String.join((CharSequence)", ", this.sagaSchema.associationKeyColumn(), this.sagaSchema.associationValueColumn(), this.sagaSchema.sagaTypeColumn(), this.sagaSchema.sagaIdColumn()) + ") VALUES(?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setString(4, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_findAssocSagaIdentifiers(Connection connection, String key, String value, String sagaType) throws SQLException {
        String sql = "SELECT " + this.sagaSchema.sagaIdColumn() + " FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE " + this.sagaSchema.associationKeyColumn() + " = ? AND " + this.sagaSchema.associationValueColumn() + " = ? AND " + this.sagaSchema.sagaTypeColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_findAssociations(Connection connection, String sagaIdentifier, String sagaType) throws SQLException {
        String sql = "SELECT " + this.sagaSchema.associationKeyColumn() + ", " + this.sagaSchema.associationValueColumn() + " FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE " + this.sagaSchema.sagaIdColumn() + " = ? AND " + this.sagaSchema.sagaTypeColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        preparedStatement.setString(2, sagaType);
        return preparedStatement;
    }

    @Override
    public String readToken(ResultSet resultSet) {
        return null;
    }

    @Override
    public Set<AssociationValue> readAssociationValues(ResultSet resultSet) throws SQLException {
        HashSet<AssociationValue> associationValues = new HashSet<AssociationValue>();
        while (resultSet.next()) {
            associationValues.add(new AssociationValue(resultSet.getString(1), resultSet.getString(2)));
        }
        return associationValues;
    }

    @Override
    public PreparedStatement sql_deleteSagaEntry(Connection connection, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.sagaEntryTable() + " WHERE " + this.sagaSchema.sagaIdColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_deleteAssociationEntries(Connection connection, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE " + this.sagaSchema.sagaIdColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_updateSaga(Connection connection, String sagaIdentifier, byte[] serializedSaga, String sagaType, String revision) throws SQLException {
        String sql = "UPDATE " + this.sagaSchema.sagaEntryTable() + " SET " + this.sagaSchema.serializedSagaColumn() + " = ?, " + this.sagaSchema.revisionColumn() + " = ? WHERE " + this.sagaSchema.sagaIdColumn() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setBytes(1, serializedSaga);
        preparedStatement.setString(2, revision);
        preparedStatement.setString(3, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_storeSaga(Connection connection, String sagaIdentifier, String revision, String sagaType, byte[] serializedSaga) throws SQLException {
        String sql = "INSERT INTO " + this.sagaSchema.sagaEntryTable() + "(" + String.join((CharSequence)", ", this.sagaSchema.sagaIdColumn(), this.sagaSchema.revisionColumn(), this.sagaSchema.sagaTypeColumn(), this.sagaSchema.serializedSagaColumn()) + ") VALUES(?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        preparedStatement.setString(2, revision);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setBytes(4, serializedSaga);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        String sql = "create table " + this.sagaSchema.associationValueEntryTable() + " (\n        id int not null AUTO_INCREMENT,\n        " + this.sagaSchema.associationKeyColumn() + " varchar(255),\n        " + this.sagaSchema.associationValueColumn() + " varchar(255),\n        " + this.sagaSchema.sagaIdColumn() + " varchar(255),\n        " + this.sagaSchema.sagaTypeColumn() + " varchar(255),\n        primary key (id)\n    );\n";
        return conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("create table " + this.sagaSchema.sagaEntryTable() + " (\n        " + this.sagaSchema.sagaIdColumn() + " varchar(255) not null,\n        " + this.sagaSchema.revisionColumn() + " varchar(255),\n        " + this.sagaSchema.sagaTypeColumn() + " varchar(255),\n        " + this.sagaSchema.serializedSagaColumn() + " blob,\n        primary key (" + this.sagaSchema.sagaIdColumn() + ")\n    );");
    }

    public SerializedObject<byte[]> readSerializedSaga(ResultSet resultSet) throws SQLException {
        return new SimpleSerializedObject((Object)resultSet.getBytes(1), byte[].class, resultSet.getString(2), resultSet.getString(3));
    }

    public SagaSchema sagaSchema() {
        return this.sagaSchema;
    }
}

