/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.command.AggregateMember;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.AnnotatedChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntityDefinition;
import org.axonframework.modelling.command.inspection.EntityModel;

public abstract class AbstractChildEntityDefinition
implements ChildEntityDefinition {
    @Override
    public <T> Optional<ChildEntity<T>> createChildDefinition(Field field, EntityModel<T> declaringEntity) {
        Map attributes = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, AggregateMember.class).orElse(null);
        if (attributes == null || !this.isFieldTypeSupported(field)) {
            return Optional.empty();
        }
        EntityModel<Object> childEntityModel = this.extractChildEntityModel(declaringEntity, attributes, field);
        ForwardingMode eventForwardingMode = this.instantiateForwardingMode(field, childEntityModel, (Class)attributes.get("eventForwardingMode"));
        return Optional.of(new AnnotatedChildEntity<Object, Object>(childEntityModel, (Boolean)attributes.get("forwardCommands"), (msg, parent) -> this.resolveCommandTarget((CommandMessage<?>)msg, (Object)parent, field, childEntityModel), (msg, parent) -> this.resolveEventTargets((EventMessage)msg, (Object)parent, field, eventForwardingMode)));
    }

    protected abstract boolean isFieldTypeSupported(Field var1);

    protected abstract <T> EntityModel<Object> extractChildEntityModel(EntityModel<T> var1, Map<String, Object> var2, Field var3);

    private ForwardingMode instantiateForwardingMode(Field field, EntityModel<Object> childEntityModel, Class<? extends ForwardingMode> forwardingModeClass) {
        ForwardingMode forwardingMode;
        try {
            forwardingMode = forwardingModeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            forwardingMode.initialize(field, childEntityModel);
        }
        catch (ReflectiveOperationException e) {
            throw new AxonConfigurationException(String.format("Failed to instantiate ForwardingMode of type [%s].", forwardingModeClass));
        }
        return forwardingMode;
    }

    protected abstract <T> Object resolveCommandTarget(CommandMessage<?> var1, T var2, Field var3, EntityModel<Object> var4);

    protected Map<String, Property<Object>> extractCommandHandlerRoutingKeys(Field field, EntityModel<Object> childEntityModel) {
        return childEntityModel.commandHandlers().stream().map(commandHandler -> commandHandler.unwrap(CommandMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(CommandMessageHandlingMember::commandName, commandHandler -> this.extractCommandHandlerRoutingKey(childEntityModel, (CommandMessageHandlingMember)commandHandler, field)));
    }

    private Property<Object> extractCommandHandlerRoutingKey(EntityModel<Object> childEntityModel, CommandMessageHandlingMember commandHandler, Field field) {
        String routingKey = (String)ObjectUtils.getOrDefault((Object)commandHandler.routingKey(), (Object)childEntityModel.routingKey());
        Property property = PropertyAccessStrategy.getProperty((Class)commandHandler.payloadType(), (String)routingKey);
        if (property == null) {
            throw new AxonConfigurationException(String.format("Command of type [%s] doesn't have a property matching the routing key [%s] necessary to route through field [%s]", commandHandler.payloadType(), routingKey, field.toGenericString()));
        }
        return property;
    }

    protected abstract <T> Stream<Object> resolveEventTargets(EventMessage var1, T var2, Field var3, ForwardingMode var4);
}

