/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.modelling.saga.AssociationResolver;
import org.axonframework.modelling.saga.SagaCreationPolicy;
import org.axonframework.modelling.saga.SagaEventHandler;
import org.axonframework.modelling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.modelling.saga.StartSaga;

public class SagaMethodMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    private final Map<Class<? extends AssociationResolver>, AssociationResolver> associationResolverMap = new HashMap<Class<? extends AssociationResolver>, AssociationResolver>();

    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        Optional annotationAttributes = original.annotationAttributes(SagaEventHandler.class);
        SagaCreationPolicy creationPolicy = original.annotationAttributes(StartSaga.class).map(attr -> attr.getOrDefault("forceNew", false) != false ? SagaCreationPolicy.ALWAYS : SagaCreationPolicy.IF_NONE_FOUND).orElse(SagaCreationPolicy.NONE);
        return annotationAttributes.map(attr -> this.doWrapHandler(original, creationPolicy, (String)attr.get("keyName"), (String)attr.get("associationProperty"), (Class)attr.get("associationResolver"))).orElse(original);
    }

    private <T> MessageHandlingMember<T> doWrapHandler(MessageHandlingMember<T> original, SagaCreationPolicy creationPolicy, String associationKeyName, String associationPropertyName, Class<? extends AssociationResolver> associationResolverClass) {
        String associationKey = this.associationKey(associationKeyName, associationPropertyName);
        AssociationResolver associationResolver = this.findAssociationResolver(associationResolverClass);
        associationResolver.validate(associationPropertyName, original);
        return new SagaMethodMessageHandlingMember<T>(original, creationPolicy, associationKey, associationPropertyName, associationResolver);
    }

    private String associationKey(String keyName, String associationProperty) {
        return "".equals(keyName) ? associationProperty : keyName;
    }

    private AssociationResolver findAssociationResolver(Class<? extends AssociationResolver> associationResolverClass) {
        return this.associationResolverMap.computeIfAbsent(associationResolverClass, this::instantiateAssociationResolver);
    }

    private AssociationResolver instantiateAssociationResolver(Class<? extends AssociationResolver> associationResolverClass) {
        try {
            return associationResolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AxonConfigurationException(String.format("`AssociationResolver` %s must define an accessible no-args constructor.", associationResolverClass.getName()), (Throwable)e);
        }
    }
}

