/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.modelling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSchema;

public class PostgresSagaSqlSchema
extends GenericSagaSqlSchema {
    private boolean exclusiveLoad = false;

    public PostgresSagaSqlSchema() {
    }

    public PostgresSagaSqlSchema(SagaSchema sagaSchema) {
        super(sagaSchema);
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.sagaSchema().associationValueEntryTable() + " (\n        id bigserial NOT NULL,\n        associationKey VARCHAR(255),\n        associationValue VARCHAR(255),\n        sagaId VARCHAR(255),\n        sagaType VARCHAR(255),\n        PRIMARY KEY (id)\n    );\n";
        return conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.sagaSchema().sagaEntryTable() + " (\n        sagaId VARCHAR(255) NOT NULL,\n        revision VARCHAR(255),\n        sagaType VARCHAR(255),\n        serializedSaga bytea,\n        PRIMARY KEY (sagaId)\n    );");
    }

    @Override
    public PreparedStatement sql_loadSaga(Connection connection, String sagaId) throws SQLException {
        if (!this.exclusiveLoad) {
            return super.sql_loadSaga(connection, sagaId);
        }
        String sql = "SELECT serializedSaga, sagaType, revision FROM " + this.sagaSchema().sagaEntryTable() + " WHERE sagaId = ? FOR UPDATE";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaId);
        return preparedStatement;
    }

    public void setExclusiveLoad(boolean exclusiveLoad) {
        this.exclusiveLoad = exclusiveLoad;
    }
}

