/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.entity.ConcreteEntityMetamodel;
import org.axonframework.modelling.entity.EntityAlreadyExistsForCreationalCommandHandlerException;
import org.axonframework.modelling.entity.EntityCommandHandler;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.EntityMetamodelBuilder;
import org.axonframework.modelling.entity.EntityMissingForInstanceCommandHandlerException;
import org.axonframework.modelling.entity.PolymorphicEntityMetamodelBuilder;
import org.axonframework.modelling.entity.WrongPolymorphicEntityTypeException;
import org.axonframework.modelling.entity.child.EntityChildMetamodel;

public class PolymorphicEntityMetamodel<E>
implements EntityMetamodel<E>,
DescribableComponent {
    private final EntityMetamodel<E> superTypeMetamodel;
    private final Map<Class<? extends E>, EntityMetamodel<? extends E>> concreteMetamodels;
    private final Set<QualifiedName> supportedCommandNames = new HashSet<QualifiedName>();
    private final Set<QualifiedName> supportedInstanceCommandNames = new HashSet<QualifiedName>();
    private final Set<QualifiedName> supportedCreationalCommandNames = new HashSet<QualifiedName>();

    private PolymorphicEntityMetamodel(EntityMetamodel<E> superTypeMetamodel, List<EntityMetamodel<? extends E>> concreteMetamodels) {
        this.superTypeMetamodel = Objects.requireNonNull(superTypeMetamodel, "The superTypeMetamodel may not be null.");
        Objects.requireNonNull(concreteMetamodels, "The concreteMetamodels may not be null.");
        this.concreteMetamodels = new HashMap<Class<? extends E>, EntityMetamodel<? extends E>>();
        this.supportedCommandNames.addAll(superTypeMetamodel.supportedCommands());
        this.supportedInstanceCommandNames.addAll(this.superTypeMetamodel.supportedInstanceCommands());
        this.supportedCreationalCommandNames.addAll(superTypeMetamodel.supportedCreationalCommands());
        for (EntityMetamodel<E> concreteMetamodel : concreteMetamodels) {
            this.concreteMetamodels.put(concreteMetamodel.entityType(), concreteMetamodel);
            this.supportedCommandNames.addAll(concreteMetamodel.supportedCommands());
            this.supportedInstanceCommandNames.addAll(concreteMetamodel.supportedInstanceCommands());
            this.supportedCreationalCommandNames.addAll(concreteMetamodel.supportedCreationalCommands());
        }
    }

    public static <E> PolymorphicEntityMetamodelBuilder<E> forSuperType(Class<E> entityType) {
        return new Builder<E>(entityType);
    }

    @Override
    public E evolve(@Nonnull E entity, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        E superTypeEvolvedEntity = this.superTypeMetamodel.evolve(entity, event, context);
        return this.metamodelFor(entity).evolve(superTypeEvolvedEntity, event, context);
    }

    private <T extends E> EntityMetamodel<T> metamodelFor(T entity) {
        return this.concreteMetamodels.get(entity.getClass());
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCommands() {
        return Collections.unmodifiableSet(this.supportedCommandNames);
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCreationalCommands() {
        return Collections.unmodifiableSet(this.supportedCreationalCommandNames);
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedInstanceCommands() {
        return Collections.unmodifiableSet(this.supportedInstanceCommandNames);
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleCreate(@Nonnull CommandMessage message, @Nonnull ProcessingContext context) {
        if (this.isInstanceCommand(message) && !this.isCreationalCommand(message)) {
            return MessageStream.failed((Throwable)new EntityMissingForInstanceCommandHandlerException(message));
        }
        for (EntityMetamodel<E> metamodel : this.concreteMetamodels.values()) {
            if (!metamodel.supportedCreationalCommands().contains(message.type().qualifiedName())) continue;
            return metamodel.handleCreate(message, context);
        }
        if (this.superTypeMetamodel.supportedCreationalCommands().contains(message.type().qualifiedName())) {
            return this.superTypeMetamodel.handleCreate(message, context);
        }
        return MessageStream.failed((Throwable)new NoHandlerForCommandException(message, this.entityType()));
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleInstance(@Nonnull CommandMessage message, @Nonnull E entity, @Nonnull ProcessingContext context) {
        if (this.isCreationalCommand(message) && !this.isInstanceCommand(message)) {
            return MessageStream.failed((Throwable)new EntityAlreadyExistsForCreationalCommandHandlerException(message, entity));
        }
        EntityMetamodel<E> concreteMetamodel = this.metamodelFor(entity);
        if (concreteMetamodel.supportedInstanceCommands().contains(message.type().qualifiedName())) {
            return concreteMetamodel.handleInstance(message, entity, context);
        }
        if (this.superTypeMetamodel.supportedInstanceCommands().contains(message.type().qualifiedName())) {
            return this.superTypeMetamodel.handleInstance(message, entity, context);
        }
        List supportingEntityTypes = this.concreteMetamodels.values().stream().filter(metamodel -> metamodel.supportedInstanceCommands().contains(message.type().qualifiedName())).map(metamodel -> metamodel.entityType()).toList();
        return MessageStream.failed((Throwable)new WrongPolymorphicEntityTypeException(message, this.entityType(), supportingEntityTypes, concreteMetamodel.entityType()));
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.superTypeMetamodel.entityType();
    }

    private boolean isCreationalCommand(CommandMessage message) {
        return this.supportedCreationalCommandNames.contains(message.type().qualifiedName());
    }

    private boolean isInstanceCommand(CommandMessage message) {
        return this.supportedInstanceCommandNames.contains(message.type().qualifiedName());
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("entityType", this.entityType());
        descriptor.describeProperty("superTypeMetamodel", this.superTypeMetamodel);
        descriptor.describeProperty("polymorphicMetamodels", this.concreteMetamodels);
    }

    public String toString() {
        return "PolymorphicEntityMetaModel{entityType=" + this.entityType().getName() + "}";
    }

    private static class Builder<E>
    implements PolymorphicEntityMetamodelBuilder<E> {
        private final EntityMetamodelBuilder<E> superTypeBuilder;
        private final List<EntityMetamodel<? extends E>> polymorphicMetamodels = new ArrayList<EntityMetamodel<? extends E>>();

        private Builder(Class<E> entityType) {
            this.superTypeBuilder = ConcreteEntityMetamodel.forEntityClass(entityType);
        }

        @Override
        @Nonnull
        public Builder<E> instanceCommandHandler(@Nonnull QualifiedName qualifiedName, @Nonnull EntityCommandHandler<E> messageHandler) {
            this.superTypeBuilder.instanceCommandHandler(qualifiedName, messageHandler);
            return this;
        }

        @Override
        @Nonnull
        public Builder<E> creationalCommandHandler(@Nonnull QualifiedName qualifiedName, @Nonnull CommandHandler messageHandler) {
            this.superTypeBuilder.creationalCommandHandler(qualifiedName, messageHandler);
            return this;
        }

        @Override
        @Nonnull
        public Builder<E> addChild(@Nonnull EntityChildMetamodel<?, E> child) {
            this.superTypeBuilder.addChild(child);
            return this;
        }

        @Override
        @Nonnull
        public Builder<E> entityEvolver(@Nullable EntityEvolver<E> entityEvolver) {
            this.superTypeBuilder.entityEvolver(entityEvolver);
            return this;
        }

        @Override
        @Nonnull
        public Builder<E> addConcreteType(@Nonnull EntityMetamodel<? extends E> metamodel) {
            Objects.requireNonNull(metamodel, "The metamodel may not be null.");
            if (this.polymorphicMetamodels.stream().anyMatch(p -> p.entityType().equals(metamodel.entityType()))) {
                throw new IllegalArgumentException("Concrete type [%s] already registered for this metamodel.".formatted(metamodel.entityType().getName()));
            }
            for (EntityMetamodel<E> existingMetamodel : this.polymorphicMetamodels) {
                if (!existingMetamodel.supportedCreationalCommands().stream().anyMatch(metamodel.supportedCreationalCommands()::contains)) continue;
                throw new IllegalArgumentException("Concrete type [%s] has creational commands that clash with existing concrete type [%s].".formatted(metamodel.entityType().getName(), existingMetamodel.entityType().getName()));
            }
            this.polymorphicMetamodels.add(metamodel);
            return this;
        }

        @Override
        @Nonnull
        public EntityMetamodel<E> build() {
            EntityMetamodel<E> metamodel = this.superTypeBuilder.build();
            return new PolymorphicEntityMetamodel<E>(metamodel, this.polymorphicMetamodels);
        }
    }
}

